/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IValueTypeLogicProgrammerElement;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeLPElementType
implements ILogicProgrammerElementType<IValueTypeLogicProgrammerElement> {
    @Override
    public IValueTypeLogicProgrammerElement getByName(String name) {
        return ValueTypes.REGISTRY.getValueType(name).createLogicProgrammerElement();
    }

    @Override
    public String getName(IValueTypeLogicProgrammerElement element) {
        return element.getValueType().getUnlocalizedName();
    }

    @Override
    public String getName() {
        return "valuetype";
    }

    @Override
    public List<IValueTypeLogicProgrammerElement> createElements() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IValueType valueType : ValueTypes.REGISTRY.getValueTypes()) {
            IValueTypeLogicProgrammerElement valueTypeLPElement = valueType.createLogicProgrammerElement();
            if (valueTypeLPElement == null) continue;
            builder.add((Object)valueTypeLPElement);
        }
        return builder.build();
    }

    public List<IValueType> getValueTypes() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IValueType valueType : ValueTypes.REGISTRY.getValueTypes()) {
            if (valueType.isCategory() || valueType.createLogicProgrammerElement() == null) continue;
            builder.add((Object)valueType);
        }
        return builder.build();
    }
}

