/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperatorSerializer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class PredicateOperator<T extends IValueType<V>, V extends IValue>
extends OperatorBase {
    private final String unlocalizedType;
    private final T inputType;
    private final List<V> rawValues;

    public PredicateOperator(T inputType, List<V> rawValues) {
        this(rawValues::contains, inputType, rawValues);
    }

    public PredicateOperator(Predicate<V> predicate, T inputType, List<V> rawValues) {
        super("pred", "pred", new IValueType[]{inputType}, ValueTypes.BOOLEAN, variables -> ValueTypeBoolean.ValueBoolean.of(predicate.test(variables.getValue(0))), IConfigRenderPattern.PREFIX_1);
        this.inputType = inputType;
        this.rawValues = rawValues;
        this.unlocalizedType = "predicate";
    }

    @Override
    protected String getUnlocalizedType() {
        return this.unlocalizedType;
    }

    @Override
    public IOperator materialize() {
        return this;
    }

    public static class Serializer
    implements IOperatorSerializer<PredicateOperator<IValueType<IValue>, IValue>> {
        @Override
        public boolean canHandle(IOperator operator) {
            return operator instanceof PredicateOperator;
        }

        @Override
        public String getUniqueName() {
            return "predicate";
        }

        @Override
        public String serialize(PredicateOperator<IValueType<IValue>, IValue> operator) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("valueType", ((PredicateOperator)operator).inputType.getUnlocalizedName());
            NBTTagList list = new NBTTagList();
            for (IValue rawValue : ((PredicateOperator)operator).rawValues) {
                list.func_74742_a((NBTBase)new NBTTagString(((PredicateOperator)operator).inputType.serialize(rawValue)));
            }
            tag.func_74782_a("values", (NBTBase)list);
            return tag.toString();
        }

        @Override
        public PredicateOperator<IValueType<IValue>, IValue> deserialize(String value) throws EvaluationException {
            try {
                NBTTagCompound tag = JsonToNBT.func_180713_a((String)value);
                IValueType valueType = ValueTypes.REGISTRY.getValueType(tag.func_74779_i("valueType"));
                NBTTagList list = tag.func_150295_c("values", MinecraftHelpers.NBTTag_Types.NBTTagString.ordinal());
                ArrayList values = Lists.newArrayList();
                for (NBTBase subTag : list) {
                    values.add(ValueHelpers.deserializeRaw(valueType, ((NBTTagString)subTag).func_150285_a_()));
                }
                return new PredicateOperator<IValueType<IValue>, IValue>(valueType, values);
            }
            catch (NBTException e) {
                throw new EvaluationException(String.format("Something went wrong while deserializing '%s'.", value));
            }
        }
    }
}

