/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.evaluate.operator.PositionedOperatorRecipeHandler;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class PositionedOperatorRecipeHandlerInputs<T extends IValueType<V>, V extends IValue>
extends PositionedOperatorRecipeHandler<T, V> {
    private static final Cache<Pair<Pair<DimPos, EnumFacing>, ValueObjectTypeIngredients.ValueIngredients>, ValueTypeList.ValueList> CACHE = CacheBuilder.newBuilder().expireAfterAccess(20L, TimeUnit.SECONDS).build();

    public PositionedOperatorRecipeHandlerInputs(DimPos pos, EnumFacing side) {
        super("recipeinputsbyoutput", new Function(), ValueTypes.LIST, pos, side);
    }

    public PositionedOperatorRecipeHandlerInputs() {
        this(null, null);
    }

    public static class Function
    extends PositionedOperatorRecipeHandler.Function {
        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeIngredients.ValueIngredients ingredients = (ValueObjectTypeIngredients.ValueIngredients)variables.getValue(0);
            IRecipeHandler recipeHandler = this.getOperator().getRecipeHandler();
            if (recipeHandler != null && ingredients.getRawValue().isPresent()) {
                Pair key = Pair.of((Object)Pair.of((Object)this.getOperator().getPos(), (Object)this.getOperator().getSide()), (Object)ingredients);
                try {
                    return (IValue)CACHE.get((Object)key, () -> {
                        IMixedIngredients givenIngredients = (IMixedIngredients)ingredients.getRawValue().get();
                        ArrayList validIngredients = Lists.newArrayList();
                        for (IRecipeDefinition recipe : recipeHandler.getRecipes()) {
                            IMixedIngredients outputIngredients = recipe.getOutput();
                            if (!PositionedOperatorRecipeHandler.validateIngredientsPartial(outputIngredients, givenIngredients)) continue;
                            validIngredients.add(ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)MixedIngredients.fromRecipeInput((IRecipeDefinition)recipe)));
                        }
                        return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_INGREDIENTS, validIngredients);
                    });
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
            return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_INGREDIENTS, Collections.emptyList());
        }
    }
}

