/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui;

import com.google.common.collect.Lists;
import java.util.Optional;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.cyclops.cyclopscore.client.gui.container.GuiContainerConfigurable;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.item.DamageIndicatedItemComponent;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMechanicalMachine;
import org.cyclops.integrateddynamics.core.tileentity.TileMechanicalMachine;

public class GuiMechanicalMachine<C extends ContainerMechanicalMachine<?>>
extends GuiContainerConfigurable<C> {
    public GuiMechanicalMachine(C container) {
        super(container);
    }

    public void drawEnergyBarTooltip(int x, int y, int width, int height, int mouseX, int mouseY) {
        GuiHelpers.renderTooltipOptional((GuiContainer)this, (int)8, (int)16, (int)18, (int)60, (int)mouseX, (int)mouseY, () -> {
            int energyStored = ((TileMechanicalMachine)((ContainerMechanicalMachine)this.getContainer()).getTile()).getEnergyStored();
            int energyMax = ((TileMechanicalMachine)((ContainerMechanicalMachine)this.getContainer()).getTile()).getMaxEnergyStored();
            if (energyMax > 0) {
                return Optional.of(Lists.newArrayList((Object[])new String[]{Helpers.getLocalizedEnergyLevel(energyStored, energyMax)}));
            }
            return Optional.empty();
        });
    }

    public void drawFluidTankTooltip(IFluidTank tank, int x, int y, int width, int height, int mouseX, int mouseY) {
        GuiHelpers.renderTooltipOptional((GuiContainer)this, (int)x, (int)y, (int)width, (int)height, (int)mouseX, (int)mouseY, () -> {
            FluidStack fluidStack = tank.getFluid();
            if (fluidStack != null) {
                String fluidName = fluidStack.getLocalizedName();
                return Optional.of(Lists.newArrayList((Object[])new String[]{fluidName, DamageIndicatedItemComponent.getInfo((FluidStack)fluidStack, (int)tank.getFluidAmount(), (int)tank.getCapacity())}));
            }
            return Optional.empty();
        });
    }
}

