/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableTypeCategory;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockLeaves;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.block.BlockMenrilSaplingConfig;
import org.cyclops.integrateddynamics.item.ItemMenrilBerriesConfig;

public class BlockMenrilLeavesConfig
extends BlockConfig {
    public static BlockMenrilLeavesConfig _instance;
    @ConfigurableProperty(category=ConfigurableTypeCategory.BLOCK, comment="A 1/x chance menril berries will be dropped when breaking a leaves block.", isCommandable=true, minimalValue=0)
    public static int berriesDropChance;

    public BlockMenrilLeavesConfig() {
        super((ModBase)IntegratedDynamics._instance, true, "menril_leaves", null, null);
    }

    protected ConfigurableBlockLeaves initSubInstance() {
        return (ConfigurableBlockLeaves)new ConfigurableBlockLeaves((ExtendedConfig)this){

            public Item func_180660_a(IBlockState iBlockState, Random random, int i) {
                return Item.func_150898_a((Block)BlockMenrilSaplingConfig._instance.getBlockInstance());
            }

            public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
                super.getDrops(drops, world, pos, state, fortune);
                if (world instanceof World && !((World)world).field_72995_K && ((World)world).field_73012_v.nextInt(berriesDropChance) == 0) {
                    drops.add((Object)new ItemStack(ItemMenrilBerriesConfig._instance.getItemInstance()));
                }
            }

            public SoundType func_185467_w() {
                return SoundType.field_185849_b;
            }

            public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
                return new ItemStack((Block)this);
            }
        }.func_149711_c(0.2f).func_149715_a(0.65f).func_149713_g(1);
    }

    public String getOreDictionaryId() {
        return "treeLeaves";
    }

    public void onRegistered() {
        Blocks.field_150480_ab.func_180686_a(this.getBlockInstance(), 5, 20);
    }

    static {
        berriesDropChance = 4;
    }
}

