/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.network;

import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.cyclops.integrateddynamics.api.network.IPartPosIteratorHandler;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PrioritizedPartPos;

public interface IPositionedAddonsNetwork {
    public static final int DEFAULT_CHANNEL = 0;
    public static final int WILDCARD_CHANNEL = -1;

    public static boolean channelsMatch(int first, int second) {
        return first == second || first == -1 || second == -1;
    }

    public int[] getChannels();

    public boolean hasPositions();

    public Collection<PrioritizedPartPos> getPrioritizedPositions(int var1);

    default public Collection<PartPos> getPositions(int channel) {
        return this.getPrioritizedPositions(channel).stream().map(PrioritizedPartPos::getPartPos).collect(Collectors.toList());
    }

    public Collection<PrioritizedPartPos> getPrioritizedPositions();

    default public Collection<PartPos> getPositions() {
        return this.getPrioritizedPositions().stream().map(PrioritizedPartPos::getPartPos).collect(Collectors.toList());
    }

    @Nullable
    public IPartPosIteratorHandler getPartPosIteratorHandler();

    public void setPartPosIteratorHandler(@Nullable IPartPosIteratorHandler var1);

    public boolean addPosition(PartPos var1, int var2, int var3);

    public void removePosition(PartPos var1);

    public boolean isPositionDisabled(PartPos var1);

    public void disablePosition(PartPos var1);

    public void enablePosition(PartPos var1);
}

