/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.advancement.criterion;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;
import org.cyclops.integrateddynamics.api.advancement.criterion.ValuePredicate;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public class JsonDeserializers {
    private JsonDeserializers() {
    }

    @Nullable
    public static IPartType deserializePartType(JsonObject jsonObject) {
        JsonElement partTypeElement = jsonObject.get("parttype");
        IPartType partType = null;
        if (partTypeElement != null && !partTypeElement.isJsonNull() && (partType = PartTypes.REGISTRY.getPartType(jsonObject.get("parttype").getAsString())) == null) {
            throw new JsonSyntaxException("No part type found with name: " + jsonObject.get("parttype").getAsString());
        }
        return partType;
    }

    @Nullable
    public static IAspect deserializeAspect(JsonObject jsonObject) {
        JsonElement aspectElement = jsonObject.get("aspect");
        IAspect aspect = null;
        if (aspectElement != null && !aspectElement.isJsonNull() && (aspect = Aspects.REGISTRY.getAspect(jsonObject.get("aspect").getAsString())) == null) {
            throw new JsonSyntaxException("No aspect found with name: " + jsonObject.get("aspect").getAsString());
        }
        return aspect;
    }

    @Nullable
    public static IValueType deserializeValueType(JsonObject jsonobject) {
        JsonElement valueTypeElement = jsonobject.get("valuetype");
        IValueType valueType = null;
        if (valueTypeElement != null && !valueTypeElement.isJsonNull() && (valueType = ValueTypes.REGISTRY.getValueType(JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"valuetype"))) == null) {
            throw new JsonSyntaxException("Unknown value type '" + JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"valuetype") + "', valid types are: " + ValueTypes.REGISTRY.getValueTypes().stream().map(IValueType::getUnlocalizedName).collect(Collectors.toList()));
        }
        return valueType;
    }

    @Nullable
    public static ValuePredicate deserializeValue(JsonObject jsonObject, @Nullable IValueType valueType) {
        return ValuePredicate.deserialize(jsonObject, valueType);
    }
}

