/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.storage.ModularStorageTileEntity;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.blocks.ModBlocks;
import mcjty.rftoolsdim.blocks.shards.AbstractDirectionalBlock;
import mcjty.rftoolsdim.config.LostCityConfiguration;
import mcjty.rftoolsdim.config.WorldgenConfiguration;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.DimletRandomizer;
import mcjty.rftoolsdim.dimensions.dimlets.KnownDimletConfiguration;
import mcjty.rftoolsdim.dimensions.types.FeatureType;
import mcjty.rftoolsdim.dimensions.types.PatreonType;
import mcjty.rftoolsdim.dimensions.types.TerrainType;
import mcjty.rftoolsdim.dimensions.world.WorldGenerationTools;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.BuildingInfo;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.GenInfo;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.LostCitiesTerrainGenerator;
import mcjty.rftoolsdim.items.ModItems;
import mcjty.rftoolsdim.varia.RarityRandomSelector;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class GenericWorldGenerator
implements IWorldGenerator {
    private static List<Function<Random, IBlockState>> machines = null;
    private static int[][] puppeteerSpawnPlatform = new int[][]{{-1, -1, -1, -1, -1, -1, -1, -1, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1, -1}, {-1, -1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1}, {-1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1}, {-1, -1, 15, 15, 15, 15, 0, 0, 0, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1}, {-1, 15, 15, 15, 15, 0, 0, 0, 0, 0, 15, 15, 15, 0, 15, 15, 15, 0, 15, 15, 15, 15, -1, -1}, {-1, 15, 15, 15, 0, 0, 15, 0, 15, 0, 0, 15, 15, 15, 0, 15, 0, 15, 15, 15, 15, 15, -1, -1}, {15, 15, 15, 15, 0, 0, 0, 0, 0, 0, 0, 15, 15, 15, 15, 0, 15, 15, 15, 15, 15, 15, 15, -1}, {15, 15, 15, 15, 0, 0, 15, 0, 15, 0, 0, 15, 15, 15, 0, 15, 0, 15, 15, 15, 15, 15, 15, -1}, {15, 15, 15, 15, 15, 0, 0, 0, 0, 0, 15, 15, 15, 0, 15, 15, 15, 0, 15, 15, 15, 15, 15, -1}, {15, 15, 15, 15, 15, 15, 0, 0, 0, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1}, {15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1}, {15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -2, 15, 0, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1}, {15, 15, 15, 15, 15, 15, 15, 15, 0, 15, 0, 15, 0, 15, 0, 15, 15, 15, 15, 15, 15, 15, 15, -1}, {-1, 15, 15, 15, 15, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 15, 15, 15, 15, -1, -1}, {-1, 15, 15, 15, 15, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 15, 15, 15, 15, -1, -1}, {-1, -1, 15, 15, 15, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 15, 15, 15, -1, -1, -1}, {-1, -1, 15, 15, 15, 15, 15, 15, 0, 15, 0, 15, 0, 15, 0, 15, 15, 15, 15, 15, 15, -1, -1, -1}, {-1, -1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1}, {-1, -1, -1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        RfToolsDimensionManager manager = RfToolsDimensionManager.getDimensionManager(world);
        if (manager.getDimensionDescriptor(world.field_73011_w.getDimension()) == null) {
            return;
        }
        DimensionInformation information = manager.getDimensionInformation(world.field_73011_w.getDimension());
        IBlockState baseBlock = information.getBaseBlockForTerrain();
        if (information.hasFeatureType(FeatureType.FEATURE_OREGEN)) {
            for (IBlockState block : information.getExtraOregen()) {
                this.addOreSpawn(block, baseBlock, world, random, chunkX * 16, chunkZ * 16, 7, 10, 12, 2, 60);
            }
        }
        Block dimensionalShardBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("rftools", "dimensional_shard_ore"));
        this.addOreSpawn(dimensionalShardBlock.func_176223_P(), Blocks.field_150348_b.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, WorldgenConfiguration.oreMinimumVeinSize, WorldgenConfiguration.oreMaximumVeinSize, WorldgenConfiguration.oreMaximumVeinCount, WorldgenConfiguration.oreMinimumHeight, WorldgenConfiguration.oreMaximumHeight);
        if (information.isPatreonBitSet(PatreonType.PATREON_PUPPETEER) && Math.abs(chunkX) <= 1 && Math.abs(chunkZ) <= 1) {
            this.generateBigSpawnPlatform(world, chunkX, chunkZ, puppeteerSpawnPlatform);
        } else if (chunkX == 0 && chunkZ == 0) {
            this.generateSpawnPlatform(world);
        } else if (!(Math.abs(chunkX) <= 6 && Math.abs(chunkZ) <= 6 || information.hasFeatureType(FeatureType.FEATURE_NODIMLETBUILDINGS) || random.nextInt(WorldgenConfiguration.dungeonChance) != 1)) {
            this.generateDimletDungeon(random, chunkX, chunkZ, world);
        }
        if ((Math.abs(chunkX) >= 2 || Math.abs(chunkZ) >= 2) && information.isPatreonBitSet(PatreonType.PATREON_COLOREDPRISMS) && random.nextInt(10) == 1) {
            this.generatePrism(chunkX, chunkZ, world);
        }
        if ((Math.abs(chunkX) >= 1 || Math.abs(chunkZ) >= 1) && information.isPatreonBitSet(PatreonType.PATREON_PINKPILLARS) && random.nextInt(2) == 1) {
            this.generatePillar(random, chunkX, chunkZ, world);
        }
        if ((Math.abs(chunkX) >= 3 || Math.abs(chunkZ) >= 3) && information.hasFeatureType(FeatureType.FEATURE_VOLCANOES) && random.nextInt(WorldgenConfiguration.volcanoChance) == 1) {
            this.generateVolcano(random, chunkX, chunkZ, world);
        }
        if (information.getTerrainType() == TerrainType.TERRAIN_LOSTCITIES) {
            this.generateLootSpawners(random, chunkX, chunkZ, world);
            this.generateVines(random, chunkX, chunkZ, world);
        }
    }

    private void generateDimletDungeon(Random random, int chunkX, int chunkZ, World world) {
        int starty4;
        int starty3;
        int starty2;
        int midx = chunkX * 16 + 8;
        int midz = chunkZ * 16 + 8;
        int starty1 = WorldGenerationTools.findSuitableEmptySpot(world, midx - 3, midz - 3);
        int starty = (starty1 + (starty2 = WorldGenerationTools.findSuitableEmptySpot(world, midx + 3, midz - 3)) + (starty3 = WorldGenerationTools.findSuitableEmptySpot(world, midx - 3, midz + 3)) + (starty4 = WorldGenerationTools.findSuitableEmptySpot(world, midx + 3, midz + 3))) / 4;
        if (starty > 1 && starty < world.func_72800_K() - 20) {
            this.generateDungeon(world, random, midx, starty, midz);
        }
    }

    private void generateVines(Random random, int chunkX, int chunkZ, World world) {
        int x;
        int y;
        int z;
        int cx = chunkX * 16;
        int cz = chunkZ * 16;
        BuildingInfo info = new BuildingInfo(chunkX, chunkZ, world.func_72905_C());
        int bottom = Math.max(66, info.hasBuilding ? 69 + info.floors * 6 : 66);
        if (info.getXmin().hasBuilding && info.getXmin().getDamageArea().getDamageFactor() < 0.4f) {
            for (z = 0; z < 15; ++z) {
                for (y = bottom; y < 63 + info.getXmin().floors * 6; ++y) {
                    if (!(random.nextFloat() < LostCityConfiguration.VINE_CHANCE)) continue;
                    this.createVineStrip(random, world, bottom, y, BlockVine.field_176280_O, cx + 0, cz + z);
                }
            }
        }
        if (info.getXmax().hasBuilding && info.getXmax().getDamageArea().getDamageFactor() < 0.4f) {
            for (z = 0; z < 15; ++z) {
                for (y = bottom; y < 63 + info.getXmax().floors * 6; ++y) {
                    if (!(random.nextFloat() < LostCityConfiguration.VINE_CHANCE)) continue;
                    this.createVineStrip(random, world, bottom, y, BlockVine.field_176278_M, cx + 15, cz + z);
                }
            }
        }
        if (info.getZmin().hasBuilding && info.getZmin().getDamageArea().getDamageFactor() < 0.4f) {
            for (x = 0; x < 15; ++x) {
                for (y = bottom; y < 63 + info.getZmin().floors * 6; ++y) {
                    if (!(random.nextFloat() < LostCityConfiguration.VINE_CHANCE)) continue;
                    this.createVineStrip(random, world, bottom, y, BlockVine.field_176273_b, cx + x, cz + 0);
                }
            }
        }
        if (info.getZmax().hasBuilding && info.getZmax().getDamageArea().getDamageFactor() < 0.4f) {
            for (x = 0; x < 15; ++x) {
                for (y = bottom; y < 63 + info.getZmax().floors * 6; ++y) {
                    if (!(random.nextFloat() < LostCityConfiguration.VINE_CHANCE)) continue;
                    this.createVineStrip(random, world, bottom, y, BlockVine.field_176279_N, cx + x, cz + 15);
                }
            }
        }
    }

    private void createVineStrip(Random random, World world, int bottom, int y, PropertyBool direction, int vinex, int vinez) {
        world.func_180501_a(new BlockPos(vinex, y, vinez), Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)direction, (Comparable)Boolean.valueOf(true)), 18);
        for (int yy = y - 1; yy >= bottom && random.nextFloat() < 0.8f; --yy) {
            world.func_180501_a(new BlockPos(vinex, yy, vinez), Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)direction, (Comparable)Boolean.valueOf(true)), 18);
        }
    }

    private void generateLootSpawners(Random random, int chunkX, int chunkZ, World world) {
        BuildingInfo info = new BuildingInfo(chunkX, chunkZ, world.func_72905_C());
        int buildingtop = 0;
        boolean building = info.hasBuilding;
        if (building) {
            buildingtop = 69 + info.floors * 6;
        }
        for (int height = 63 - info.floorsBelowGround * 6; height < buildingtop; ++height) {
            BlockPos pos;
            int f = LostCitiesTerrainGenerator.getFloor(height);
            if (f != 0) continue;
            BlockPos floorpos = new BlockPos(chunkX * 16, height, chunkZ * 16);
            int floortype = info.floorTypes[LostCitiesTerrainGenerator.getLevel(height) + info.floorsBelowGround];
            GenInfo getInfo = LostCitiesTerrainGenerator.getGenInfos().get(Pair.of((Object)info.getGenInfoIndex(), (Object)floortype));
            for (BlockPos blockPos : getInfo.getChest()) {
                pos = floorpos.func_177971_a((Vec3i)blockPos);
                if (world.func_175623_d(pos)) continue;
                this.createLootChest(random, world, pos);
            }
            for (BlockPos blockPos : getInfo.getRandomFeatures()) {
                pos = floorpos.func_177971_a((Vec3i)blockPos);
                if (world.func_175623_d(pos)) continue;
                this.createRandomFeature(random, world, pos);
            }
            for (BlockPos blockPos : getInfo.getModularStorages()) {
                pos = floorpos.func_177971_a((Vec3i)blockPos);
                if (world.func_175623_d(pos)) continue;
                this.createModularStorage(random, world, pos);
            }
            for (BlockPos blockPos : getInfo.getRandomRFToolsMachines()) {
                pos = floorpos.func_177971_a((Vec3i)blockPos);
                if (world.func_175623_d(pos)) continue;
                this.createRFToolsMachine(random, world, pos);
            }
            for (Map.Entry entry : getInfo.getSpawnerType().entrySet()) {
                pos = floorpos.func_177971_a((Vec3i)entry.getKey());
                if (world.func_175623_d(pos)) continue;
                world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 18);
                TileEntity tileentity = world.func_175625_s(pos);
                if (!(tileentity instanceof TileEntityMobSpawner)) continue;
                TileEntityMobSpawner spawner = (TileEntityMobSpawner)tileentity;
                switch ((Integer)entry.getValue()) {
                    case 1: {
                        MobSpawnerBaseLogic mobspawnerbaselogic3 = spawner.func_145881_a();
                        mobspawnerbaselogic3.func_190894_a(new ResourceLocation("minecraft:zombie"));
                        spawner.func_70296_d();
                        break;
                    }
                    case 2: {
                        MobSpawnerBaseLogic mobspawnerbaselogic2 = spawner.func_145881_a();
                        mobspawnerbaselogic2.func_190894_a(new ResourceLocation("minecraft:skeleton"));
                        spawner.func_70296_d();
                        break;
                    }
                    case 3: {
                        MobSpawnerBaseLogic mobspawnerbaselogic1 = spawner.func_145881_a();
                        mobspawnerbaselogic1.func_190894_a(new ResourceLocation("minecraft:spider"));
                        spawner.func_70296_d();
                        break;
                    }
                    case 4: {
                        MobSpawnerBaseLogic mobspawnerbaselogic = spawner.func_145881_a();
                        mobspawnerbaselogic.func_190894_a(new ResourceLocation("minecraft:blaze"));
                        spawner.func_70296_d();
                    }
                }
            }
        }
    }

    private void createRandomFeature(Random random, World world, BlockPos pos) {
        switch (random.nextInt(60)) {
            case 0: 
            case 1: {
                world.func_180501_a(pos, Blocks.field_150382_bo.func_176223_P(), 18);
                break;
            }
            case 2: 
            case 3: {
                world.func_180501_a(pos, Blocks.field_150467_bQ.func_176223_P(), 18);
                break;
            }
            case 4: 
            case 5: {
                world.func_180501_a(pos, Blocks.field_150383_bp.func_176223_P(), 18);
                break;
            }
            case 6: {
                world.func_180501_a(pos, Blocks.field_150381_bn.func_176223_P(), 18);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                world.func_180501_a(pos, Blocks.field_150462_ai.func_176223_P(), 18);
                break;
            }
            case 20: {
                this.createModularStorage(random, world, pos);
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                world.func_180501_a(pos, Blocks.field_150321_G.func_176223_P(), 18);
                break;
            }
            default: {
                world.func_180501_a(pos, Blocks.field_150460_al.func_176223_P(), 18);
            }
        }
    }

    private void createModularStorage(Random random, World world, BlockPos pos) {
        Block storageBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("rftools", "modular_storage"));
        if (storageBlock instanceof BlockAir) {
            return;
        }
        ItemStack module = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("rftools", "storage_module")));
        world.func_180501_a(pos, storageBlock.func_176223_P().func_177226_a((IProperty)BaseBlock.FACING, (Comparable)EnumFacing.field_176754_o[random.nextInt(EnumFacing.field_176754_o.length)]), 18);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ModularStorageTileEntity) {
            ModularStorageTileEntity storage = (ModularStorageTileEntity)te;
            storage.func_70299_a(0, module);
            for (int i = 0; i < 5 + random.nextInt(10); ++i) {
                storage.func_70299_a(i + 3, this.randomLoot(random));
            }
        }
    }

    private static void initMachines() {
        Block crafter2;
        Block rf_monitor;
        Block powercell_simple;
        machines = new ArrayList<Function<Random, IBlockState>>();
        Block crafter1 = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("rftools", "crafter1"));
        if (!(crafter1 instanceof BlockAir)) {
            machines.add(random -> crafter1.func_176223_P().func_177226_a((IProperty)BaseBlock.FACING, (Comparable)EnumFacing.field_176754_o[random.nextInt(EnumFacing.field_176754_o.length)]));
        }
        if (!((powercell_simple = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("rftools", "powercell_simple"))) instanceof BlockAir)) {
            machines.add(random -> powercell_simple.func_176223_P());
        }
        if (!((rf_monitor = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("rftools", "rf_monitor"))) instanceof BlockAir)) {
            machines.add(random -> rf_monitor.func_176223_P().func_177226_a((IProperty)BaseBlock.FACING, (Comparable)EnumFacing.field_176754_o[random.nextInt(EnumFacing.field_176754_o.length)]));
        }
        if (!((crafter2 = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("rftools", "crafter2"))) instanceof BlockAir)) {
            machines.add(random -> crafter2.func_176223_P().func_177226_a((IProperty)BaseBlock.FACING, (Comparable)EnumFacing.field_176754_o[random.nextInt(EnumFacing.field_176754_o.length)]));
        }
    }

    private void createRFToolsMachine(Random random, World world, BlockPos pos) {
        if (machines == null) {
            GenericWorldGenerator.initMachines();
        }
        if (!machines.isEmpty()) {
            world.func_180501_a(pos, machines.get(random.nextInt(machines.size())).apply(random), 18);
        }
    }

    private ItemStack randomLoot(Random rand) {
        switch (rand.nextInt(10)) {
            case 0: {
                return DimletRandomizer.getRandomPart(rand);
            }
            case 1: {
                return DimletRandomizer.getRandomPart(rand);
            }
            case 2: {
                RarityRandomSelector.Distribution bestDistribution = DimletRandomizer.getRandomDimlets().createDistribution(0.2f);
                DimletKey key = (DimletKey)bestDistribution.select(rand);
                if (key != null) {
                    return KnownDimletConfiguration.getDimletStack(key);
                }
                return ItemStack.field_190927_a;
            }
            case 3: {
                return new ItemStack((Item)ModItems.dimletParcelItem, 1 + rand.nextInt(3));
            }
        }
        return new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("rftools", "dimensional_shard")), rand.nextInt(20) + 10);
    }

    private void createLootChest(Random random, World world, BlockPos pos) {
        world.func_180501_a(pos, Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.SOUTH), 18);
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityChest) {
            switch (random.nextInt(30)) {
                case 0: {
                    ((TileEntityChest)tileentity).func_189404_a(LootTableList.field_186429_k, random.nextLong());
                    break;
                }
                case 1: {
                    ((TileEntityChest)tileentity).func_189404_a(LootTableList.field_186430_l, random.nextLong());
                    break;
                }
                case 2: {
                    ((TileEntityChest)tileentity).func_189404_a(LootTableList.field_186423_e, random.nextLong());
                    break;
                }
                case 3: {
                    ((TileEntityChest)tileentity).func_189404_a(LootTableList.field_186424_f, random.nextLong());
                    break;
                }
                case 4: {
                    ((TileEntityChest)tileentity).func_189404_a(LootTableList.field_186425_g, random.nextLong());
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    ((TileEntityChest)tileentity).func_189404_a(LostCitiesTerrainGenerator.LOOT, random.nextLong());
                    break;
                }
                default: {
                    ((TileEntityChest)tileentity).func_189404_a(LootTableList.field_186422_d, random.nextLong());
                }
            }
        }
    }

    private void generateVolcano(Random random, int chunkX, int chunkZ, World world) {
        int x = chunkX * 16 + random.nextInt(16);
        int z = chunkZ * 16 + random.nextInt(16);
        int cntsolid = 0;
        for (int y = world.func_175672_r(new BlockPos(x, 0, z)).func_177956_o(); y > 3; --y) {
            if (WorldGenerationTools.isSolid(world, x, y, z)) {
                if (++cntsolid <= 5) continue;
                Logging.log((String)("Spawned volcano block at " + x + "," + y + "," + z));
                break;
            }
            cntsolid = 0;
        }
    }

    private void generatePrism(int chunkX, int chunkZ, World world) {
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        int y = world.func_175672_r(new BlockPos(x, 0, z)).func_177956_o();
        int y1 = world.func_175672_r(new BlockPos(x - 7, 0, z - 7)).func_177956_o();
        if (y1 < y) {
            y = y1;
        }
        if ((y1 = world.func_175672_r(new BlockPos(x + 7, 0, z - 7)).func_177956_o()) < y) {
            y = y1;
        }
        if ((y1 = world.func_175672_r(new BlockPos(x - 7, 0, z + 7)).func_177956_o()) < y) {
            y = y1;
        }
        if ((y1 = world.func_175672_r(new BlockPos(x + 7, 0, z + 7)).func_177956_o()) < y) {
            y = y1;
        }
        if (y > 10 && y < 230) {
            for (int i = 7; i >= 0; --i) {
                if (i == 0) {
                    this.setStainedGlassIfAir(world, x, y, z, i);
                } else {
                    for (int j = -i; j <= i - 1; ++j) {
                        this.setStainedGlassIfAir(world, x + j + 1, y, z + i, i);
                        this.setStainedGlassIfAir(world, x + i, y, z + j, i);
                        this.setStainedGlassIfAir(world, x - j - 1, y, z - i, i);
                        this.setStainedGlassIfAir(world, x - i, y, z - j, i);
                    }
                }
                ++y;
            }
        }
    }

    private void setStainedGlassIfAir(World world, int x, int y, int z, int i) {
        if (world.func_175623_d(new BlockPos(x, y, z))) {
            world.func_180501_a(new BlockPos(x, y, z), Blocks.field_150399_cn.func_176203_a(i), 18);
        }
    }

    private void generatePillar(Random random, int chunkX, int chunkZ, World world) {
        int z;
        int x = chunkX * 16 + random.nextInt(16);
        int y = world.func_175672_r(new BlockPos(x, 0, z = chunkZ * 16 + random.nextInt(16))).func_177956_o();
        if (y > 10 && y < 240) {
            for (int i = 0; i < random.nextInt(3) + 2; ++i) {
                world.func_180501_a(new BlockPos(x, y++, z), Blocks.field_150406_ce.func_176203_a(6), 18);
            }
            world.func_180501_a(new BlockPos(x, y, z), Blocks.field_150399_cn.func_176203_a(6), 18);
        }
    }

    private boolean isReceiverPresent(World world, int midx, int midz, int starty, int[][] platform) {
        int r = platform.length;
        int sx = -r / 2;
        int sz = -r / 2;
        for (int x = sx; x < sx + r; ++x) {
            for (int z = sz; z < sz + r; ++z) {
                int color = platform[r - x - r / 2 - 1][z + r / 2];
                if (color != -2 || RFToolsDim.teleportationManager.getReceiverName(world, new BlockPos(x + midx, starty, z + midz)) == null) continue;
                return true;
            }
        }
        return false;
    }

    private void generateBigSpawnPlatform(World world, int chunkX, int chunkZ, int[][] platform) {
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        DimensionInformation information = dimensionManager.getDimensionInformation(world.field_73011_w.getDimension());
        int midx = 8;
        int midz = 8;
        int starty = WorldGenerationTools.findSuitableEmptySpot(world, midx, midz);
        starty = starty == -1 ? 64 : ++starty;
        if (this.isReceiverPresent(world, midx, midz, starty - 1, platform)) {
            --starty;
        }
        int r = platform.length;
        int sx = -r / 2;
        int sz = -r / 2;
        for (int x = sx; x < sx + r; ++x) {
            int cx = x + midx >> 4;
            if (chunkX != cx) continue;
            for (int z = sz; z < sz + r; ++z) {
                int cz = z + midz >> 4;
                if (chunkZ != cz) continue;
                int color = platform[r - x - r / 2 - 1][z + r / 2];
                if (color == -2) {
                    RFToolsDim.teleportationManager.createReceiver(world, new BlockPos(x + midx, starty, z + midz), information.getName(), -1);
                } else if (color != -1) {
                    world.func_180501_a(new BlockPos(x + midx, starty, z + midz), Blocks.field_150406_ce.func_176203_a(color), 18);
                } else {
                    world.func_175698_g(new BlockPos(x + midx, starty, z + midz));
                }
                for (int y = 1; y <= 3; ++y) {
                    world.func_175698_g(new BlockPos(x + midx, starty + y, z + midz));
                }
            }
        }
        if (chunkX == 0 && chunkZ == 0) {
            this.registerReceiver(world, dimensionManager, information, midx, midz, starty);
        }
    }

    private void generateSpawnPlatform(World world) {
        int y;
        int z;
        int x;
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        DimensionInformation information = dimensionManager.getDimensionInformation(world.field_73011_w.getDimension());
        int midx = 8;
        int midz = 8;
        int starty = information.getTerrainType() == TerrainType.TERRAIN_SOLID ? 64 : (information.getTerrainType() == TerrainType.TERRAIN_INVERTIGO ? WorldGenerationTools.findUpsideDownEmptySpot(world, midx, midz) : WorldGenerationTools.findSuitableEmptySpot(world, midx, midz));
        starty = starty == -1 ? 64 : ++starty;
        boolean shelter = information.isShelter();
        if (information.getTerrainType() == TerrainType.TERRAIN_LIQUID) {
            shelter = true;
        }
        int bounds = 3;
        if (shelter) {
            bounds = 4;
        }
        for (x = -bounds; x <= bounds; ++x) {
            for (z = -bounds; z <= bounds; ++z) {
                if (x == 0 && z == 0) {
                    RFToolsDim.teleportationManager.createReceiver(world, new BlockPos(x + midx, starty, z + midz), information.getName(), -1);
                } else if (x == 0 && (z == 2 || z == -2)) {
                    world.func_180501_a(new BlockPos(x + midx, starty, z + midz), Blocks.field_150426_aN.func_176223_P(), 3);
                } else {
                    world.func_180501_a(new BlockPos(x + midx, starty, z + midz), Blocks.field_150406_ce.func_176203_a(3), 18);
                }
                for (y = 1; y <= 3; ++y) {
                    world.func_175698_g(new BlockPos(x + midx, starty + y, z + midz));
                }
                if (world.func_175623_d(new BlockPos(x + midx, starty + 4, z + midz))) continue;
                world.func_180501_a(new BlockPos(x + midx, starty + 4, z + midz), Blocks.field_150406_ce.func_176203_a(3), 18);
            }
        }
        if (shelter) {
            for (int y2 = 1; y2 <= 3; ++y2) {
                for (int x2 = -bounds; x2 <= bounds; ++x2) {
                    for (int z2 = -bounds; z2 <= bounds; ++z2) {
                        if (x2 != -bounds && x2 != bounds && z2 != -bounds && z2 != bounds) continue;
                        if (z2 == 0 && y2 >= 2 && y2 <= 3 || x2 == 0 && y2 >= 2 && y2 <= 3 && z2 == bounds) {
                            world.func_180501_a(new BlockPos(x2 + midx, starty + y2, z2 + midz), Blocks.field_150410_aZ.func_176203_a(0), 18);
                            continue;
                        }
                        if (x2 == 0 && y2 == 1 && z2 == -bounds) {
                            world.func_180501_a(new BlockPos(x2 + midx, starty + y2, z2 + midz), Blocks.field_150454_av.func_176203_a(1), 18);
                            continue;
                        }
                        if (x2 == 0 && y2 == 2 && z2 == -bounds) {
                            world.func_180501_a(new BlockPos(x2 + midx, starty + y2, z2 + midz), Blocks.field_150454_av.func_176203_a(8), 18);
                            continue;
                        }
                        world.func_180501_a(new BlockPos(x2 + midx, starty + y2, z2 + midz), Blocks.field_150406_ce.func_176203_a(9), 18);
                    }
                }
            }
            for (x = -bounds; x <= bounds; ++x) {
                for (z = -bounds; z <= bounds; ++z) {
                    world.func_180501_a(new BlockPos(x + midx, starty + 4, z + midz), Blocks.field_150406_ce.func_176203_a(9), 18);
                }
            }
            for (x = -1; x <= 1; ++x) {
                for (z = -bounds - 2; z <= -bounds - 1; ++z) {
                    world.func_180501_a(new BlockPos(x + midx, starty, z + midz), Blocks.field_150406_ce.func_176203_a(3), 18);
                    for (y = 1; y <= 3; ++y) {
                        world.func_175698_g(new BlockPos(x + midx, starty + y, z + midz));
                    }
                    if (world.func_175623_d(new BlockPos(x + midx, starty + 4, z + midz))) continue;
                    world.func_180501_a(new BlockPos(x + midx, starty + 4, z + midz), Blocks.field_150406_ce.func_176203_a(9), 18);
                }
            }
            world.func_180501_a(new BlockPos(midx - 1, starty + 2, midz - bounds - 1), Blocks.field_150430_aB.func_176203_a(4), 18);
            world.func_180501_a(new BlockPos(midx + 1, starty + 2, midz - bounds + 1), Blocks.field_150430_aB.func_176203_a(3), 18);
        }
        this.registerReceiver(world, dimensionManager, information, midx, midz, starty);
    }

    private void registerReceiver(World world, RfToolsDimensionManager dimensionManager, DimensionInformation information, int midx, int midz, int starty) {
        information.setSpawnPoint(new BlockPos(midx, starty, midz));
        dimensionManager.save(world);
    }

    private void generateDungeon(World world, Random random, int midx, int starty, int midz) {
        int i;
        int x;
        AbstractDirectionalBlock cornerBlock;
        boolean doSmallAntenna = random.nextInt(4) == 0;
        boolean doExtraFeature = random.nextInt(4) == 0;
        switch (random.nextInt(4)) {
            case 0: {
                cornerBlock = ModBlocks.dimensionalCrossBlock;
                break;
            }
            case 1: {
                cornerBlock = ModBlocks.dimensionalPattern1Block;
                break;
            }
            case 2: {
                cornerBlock = ModBlocks.dimensionalPattern2Block;
                break;
            }
            default: {
                cornerBlock = ModBlocks.dimensionalCross2Block;
            }
        }
        Block buildingBlock = Blocks.field_150406_ce;
        int color = random.nextInt(5);
        if (color == 0) {
            color = 3;
        } else if (color == 1) {
            color = 9;
        } else if (color == 2) {
            color = 11;
        } else {
            color = 0;
            buildingBlock = ModBlocks.dimensionalBlankBlock;
        }
        for (x = midx - 3; x <= midx + 3; ++x) {
            for (int z = midz - 3; z <= midz + 3; ++z) {
                boolean corner = !(x != midx - 3 && x != midx + 3 || z != midz - 3 && z != midz + 3);
                boolean xside = x == midx - 3 || x == midx + 3;
                boolean zside = z == midz - 3 || z == midz + 3;
                boolean antenna = x == midx - 2 && z == midz - 2;
                boolean smallAntenna = doSmallAntenna && x == midx + 2 && z == midz + 2;
                world.func_180501_a(new BlockPos(x, starty, z), Blocks.field_150334_T.func_176223_P(), 18);
                if (corner) {
                    world.func_180501_a(new BlockPos(x, starty + 1, z), cornerBlock.func_176203_a(1), 18);
                    world.func_180501_a(new BlockPos(x, starty + 2, z), cornerBlock.func_176203_a(1), 18);
                    world.func_180501_a(new BlockPos(x, starty + 3, z), cornerBlock.func_176203_a(1), 18);
                } else if (xside) {
                    world.func_180501_a(new BlockPos(x, starty + 1, z), buildingBlock.func_176203_a(color), 18);
                    if (z >= midz - 1 && z <= midz + 1) {
                        world.func_180501_a(new BlockPos(x, starty + 2, z), Blocks.field_150410_aZ.func_176203_a(0), 18);
                    } else {
                        world.func_180501_a(new BlockPos(x, starty + 2, z), buildingBlock.func_176203_a(color), 18);
                    }
                    world.func_180501_a(new BlockPos(x, starty + 3, z), buildingBlock.func_176203_a(color), 18);
                } else if (zside) {
                    world.func_180501_a(new BlockPos(x, starty + 1, z), buildingBlock.func_176203_a(color), 18);
                    world.func_180501_a(new BlockPos(x, starty + 2, z), buildingBlock.func_176203_a(color), 18);
                    world.func_180501_a(new BlockPos(x, starty + 3, z), buildingBlock.func_176203_a(color), 18);
                } else {
                    world.func_175698_g(new BlockPos(x, starty + 1, z));
                    world.func_175698_g(new BlockPos(x, starty + 2, z));
                    world.func_175698_g(new BlockPos(x, starty + 3, z));
                }
                if (antenna) {
                    world.func_180501_a(new BlockPos(x, starty + 4, z), Blocks.field_150334_T.func_176223_P(), 18);
                    world.func_180501_a(new BlockPos(x, starty + 5, z), Blocks.field_150411_aY.func_176223_P(), 18);
                    world.func_180501_a(new BlockPos(x, starty + 6, z), Blocks.field_150411_aY.func_176223_P(), 18);
                    world.func_180501_a(new BlockPos(x, starty + 7, z), Blocks.field_150411_aY.func_176223_P(), 18);
                    world.func_180501_a(new BlockPos(x, starty + 8, z), Blocks.field_150426_aN.func_176223_P(), 3);
                } else if (smallAntenna) {
                    world.func_180501_a(new BlockPos(x, starty + 4, z), Blocks.field_150334_T.func_176223_P(), 18);
                    world.func_180501_a(new BlockPos(x, starty + 5, z), Blocks.field_150411_aY.func_176223_P(), 18);
                    world.func_175698_g(new BlockPos(x, starty + 6, z));
                    world.func_175698_g(new BlockPos(x, starty + 7, z));
                    world.func_175698_g(new BlockPos(x, starty + 8, z));
                } else {
                    world.func_180501_a(new BlockPos(x, starty + 4, z), Blocks.field_150333_U.func_176223_P(), 18);
                    world.func_175698_g(new BlockPos(x, starty + 5, z));
                    world.func_175698_g(new BlockPos(x, starty + 6, z));
                    world.func_175698_g(new BlockPos(x, starty + 7, z));
                    world.func_175698_g(new BlockPos(x, starty + 8, z));
                }
                WorldGenerationTools.fillEmptyWithStone(world, x, starty - 1, z);
            }
        }
        if (doExtraFeature) {
            if (!WorldGenerationTools.isSolid(world, midx + 4, starty, midz - 3)) {
                world.func_180501_a(new BlockPos(midx + 4, starty, midz - 3), Blocks.field_150411_aY.func_176223_P(), 18);
            }
            world.func_180501_a(new BlockPos(midx + 4, starty + 1, midz - 3), Blocks.field_150411_aY.func_176223_P(), 18);
            world.func_180501_a(new BlockPos(midx + 4, starty + 2, midz - 3), Blocks.field_150411_aY.func_176223_P(), 18);
            if (!WorldGenerationTools.isSolid(world, midx + 5, starty, midz - 3)) {
                world.func_180501_a(new BlockPos(midx + 5, starty, midz - 3), buildingBlock.func_176203_a(color), 18);
            }
            world.func_180501_a(new BlockPos(midx + 5, starty + 1, midz - 3), buildingBlock.func_176203_a(color), 18);
            world.func_180501_a(new BlockPos(midx + 5, starty + 2, midz - 3), buildingBlock.func_176203_a(color), 18);
            WorldGenerationTools.fillEmptyWithStone(world, midx + 4, starty - 1, midz - 3);
            WorldGenerationTools.fillEmptyWithStone(world, midx + 5, starty - 1, midz - 3);
        }
        for (x = midx - 3; x <= midx + 3; ++x) {
            for (int y = starty + 1; y <= starty + 3; ++y) {
                world.func_175698_g(new BlockPos(x, y, midz - 4));
            }
        }
        world.func_180501_a(new BlockPos(midx - 1, starty, midz - 4), Blocks.field_150334_T.func_176223_P(), 18);
        world.func_180501_a(new BlockPos(midx, starty, midz - 4), Blocks.field_150334_T.func_176223_P(), 18);
        world.func_180501_a(new BlockPos(midx + 1, starty, midz - 4), Blocks.field_150334_T.func_176223_P(), 18);
        world.func_180501_a(new BlockPos(midx, starty + 1, midz - 3), Blocks.field_150454_av.func_176203_a(1), 18);
        world.func_180501_a(new BlockPos(midx, starty + 2, midz - 3), Blocks.field_150454_av.func_176203_a(8), 18);
        world.func_180501_a(new BlockPos(midx - 1, starty + 2, midz - 4), Blocks.field_150430_aB.func_176203_a(4), 18);
        world.func_180501_a(new BlockPos(midx + 1, starty + 2, midz - 2), Blocks.field_150430_aB.func_176203_a(3), 18);
        world.func_180501_a(new BlockPos(midx, starty + 3, midz + 3), Blocks.field_150379_bu.func_176223_P(), 18);
        world.func_180501_a(new BlockPos(midx, starty + 3, midz + 2), Blocks.field_150442_at.func_176203_a(4), 18);
        world.func_180501_a(new BlockPos(midx + 2, starty + 1, midz - 2), Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.SOUTH), 18);
        RarityRandomSelector.Distribution randomDimletsBestDistribution = DimletRandomizer.getRandomDimlets().createDistribution(0.2f);
        RarityRandomSelector.Distribution randomUncraftableDimletsBestDistribution = DimletRandomizer.getRandomUncraftableDimlets().createDistribution(0.2f);
        TileEntityChest chest = (TileEntityChest)world.func_175625_s(new BlockPos(midx + 2, starty + 1, midz - 2));
        for (i = 0; i < random.nextInt(4) + 3; ++i) {
            ItemStack stack = DimletRandomizer.getRandomPart(random);
            chest.func_70299_a(random.nextInt(chest.func_70302_i_()), stack);
        }
        if (WorldgenConfiguration.enableDimletsInRFToolsDungeons > 0) {
            for (i = 0; i < random.nextInt(WorldgenConfiguration.enableDimletsInRFToolsDungeons); ++i) {
                DimletKey key = (DimletKey)randomDimletsBestDistribution.select(random);
                if (key == null) continue;
                ItemStack stack = KnownDimletConfiguration.getDimletStack(key);
                chest.func_70299_a(random.nextInt(chest.func_70302_i_()), stack);
            }
        }
        for (i = 0; i < WorldgenConfiguration.uncraftableDimletsInRFToolsDungeons; ++i) {
            DimletKey key = (DimletKey)randomUncraftableDimletsBestDistribution.select(random);
            if (key == null) continue;
            ItemStack stack = KnownDimletConfiguration.getDimletStack(key);
            chest.func_70299_a(random.nextInt(chest.func_70302_i_()), stack);
        }
        for (i = 0; i < random.nextInt(2); ++i) {
            chest.func_70299_a(random.nextInt(chest.func_70302_i_()), new ItemStack((Item)ModItems.dimletParcelItem));
        }
        EntityItemFrame frame1 = this.spawnItemFrame(world, midx - 1, starty + 2, midz + 2);
        EntityItemFrame frame2 = this.spawnItemFrame(world, midx, starty + 2, midz + 2);
        EntityItemFrame frame3 = this.spawnItemFrame(world, midx + 1, starty + 2, midz + 2);
        if (WorldgenConfiguration.enableDimletsInRFToolsFrames) {
            DimletKey rd3;
            DimletKey rd2;
            DimletKey rd1 = (DimletKey)randomDimletsBestDistribution.select(random);
            if (rd1 != null) {
                frame1.func_82334_a(KnownDimletConfiguration.getDimletStack(rd1));
            }
            if ((rd2 = (DimletKey)randomDimletsBestDistribution.select(random)) != null) {
                frame2.func_82334_a(KnownDimletConfiguration.getDimletStack(rd2));
            }
            if ((rd3 = (DimletKey)randomDimletsBestDistribution.select(random)) != null) {
                frame3.func_82334_a(KnownDimletConfiguration.getDimletStack(rd3));
            }
        } else {
            frame1.func_82334_a(DimletRandomizer.getRandomPart(random));
            frame2.func_82334_a(DimletRandomizer.getRandomPart(random));
            frame3.func_82334_a(DimletRandomizer.getRandomPart(random));
        }
    }

    private EntityItemFrame spawnItemFrame(World world, int x, int y, int z) {
        EntityItemFrame frame = new EntityItemFrame(world, new BlockPos(x, y, z + 1), EnumFacing.NORTH);
        world.func_72838_d((Entity)frame);
        frame.func_70107_b((double)x, (double)y, (double)z);
        return frame;
    }

    public void addOreSpawn(IBlockState block, IBlockState targetBlock, World world, Random random, int blockXPos, int blockZPos, int minVeinSize, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        WorldGenMinable minable = new WorldGenMinable(block, minVeinSize - random.nextInt(maxVeinSize - minVeinSize), p -> p == targetBlock);
        for (int i = 0; i < chancesToSpawn; ++i) {
            int posX = blockXPos + random.nextInt(16);
            int posY = minY + random.nextInt(maxY - minY);
            int posZ = blockZPos + random.nextInt(16);
            minable.func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }
}

