/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.types;

import java.util.HashMap;
import java.util.Map;

public enum SpecialType {
    SPECIAL_PEACEFUL("Peaceful", true),
    SPECIAL_EFFICIENCY("Efficiency", true),
    SPECIAL_EFFICIENCY_LOW("MediocreEfficiency", true),
    SPECIAL_SHELTER("Shelter", false),
    SPECIAL_SEED("Seed", false),
    SPECIAL_SPAWN("Spawn", true),
    SPECIAL_NOANIMALS("NoAnimals", true),
    SPECIAL_OWNER("Owner", false),
    SPECIAL_CHEATER("Cheater", true);

    private static final Map<String, SpecialType> SPECIAL_TYPE_MAP;
    private final String id;
    private final boolean injectable;

    private SpecialType(String id, boolean isInjectable) {
        this.id = id;
        this.injectable = isInjectable;
    }

    public String getId() {
        return this.id;
    }

    public boolean isInjectable() {
        return this.injectable;
    }

    public static SpecialType getSpecialById(String id) {
        return SPECIAL_TYPE_MAP.get(id);
    }

    static {
        SPECIAL_TYPE_MAP = new HashMap<String, SpecialType>();
        for (SpecialType type : SpecialType.values()) {
            SPECIAL_TYPE_MAP.put(type.getId(), type);
        }
    }
}

