/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.types;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletType;
import mcjty.rftoolsdim.dimensions.types.TerrainType;

public enum FeatureType {
    FEATURE_NONE("None", null, null, 0, 0),
    FEATURE_CAVES("Caves", new TSet(new TerrainType[]{TerrainType.TERRAIN_AMPLIFIED, TerrainType.TERRAIN_CAVERN, TerrainType.TERRAIN_FLOODED_CAVERN, TerrainType.TERRAIN_CHAOTIC, TerrainType.TERRAIN_FLAT, TerrainType.TERRAIN_ISLAND, TerrainType.TERRAIN_ISLANDS, TerrainType.TERRAIN_LOW_CAVERN, TerrainType.TERRAIN_NORMAL, TerrainType.TERRAIN_PLATEAUS, TerrainType.TERRAIN_NEARLANDS, TerrainType.TERRAIN_SOLID, TerrainType.TERRAIN_WAVES, TerrainType.TERRAIN_FILLEDWAVES, TerrainType.TERRAIN_ROUGH}), null, 0, 0),
    FEATURE_RAVINES("Ravines", new TSet(new TerrainType[]{TerrainType.TERRAIN_AMPLIFIED, TerrainType.TERRAIN_CAVERN, TerrainType.TERRAIN_FLOODED_CAVERN, TerrainType.TERRAIN_CHAOTIC, TerrainType.TERRAIN_FLAT, TerrainType.TERRAIN_ISLAND, TerrainType.TERRAIN_ISLANDS, TerrainType.TERRAIN_LOW_CAVERN, TerrainType.TERRAIN_NORMAL, TerrainType.TERRAIN_PLATEAUS, TerrainType.TERRAIN_NEARLANDS, TerrainType.TERRAIN_SOLID, TerrainType.TERRAIN_WAVES, TerrainType.TERRAIN_FILLEDWAVES, TerrainType.TERRAIN_ROUGH}), null, 0, 0),
    FEATURE_ORBS("Orbs", null, new MMap(-1, new DimletType[]{DimletType.DIMLET_MATERIAL}), 1, 0),
    FEATURE_OREGEN("Oregen", null, new MMap(-1, new DimletType[]{DimletType.DIMLET_MATERIAL}), 0, 0),
    FEATURE_LAKES("Lakes", new TSet(new TerrainType[]{TerrainType.TERRAIN_AMPLIFIED, TerrainType.TERRAIN_CAVERN, TerrainType.TERRAIN_CHAOTIC, TerrainType.TERRAIN_FLAT, TerrainType.TERRAIN_ISLAND, TerrainType.TERRAIN_ISLANDS, TerrainType.TERRAIN_LOW_CAVERN, TerrainType.TERRAIN_NORMAL, TerrainType.TERRAIN_PLATEAUS, TerrainType.TERRAIN_NEARLANDS, TerrainType.TERRAIN_SOLID, TerrainType.TERRAIN_WAVES, TerrainType.TERRAIN_FILLEDWAVES, TerrainType.TERRAIN_ROUGH}), new MMap(-1, new DimletType[]{DimletType.DIMLET_LIQUID}), 0, 0),
    FEATURE_TENDRILS("Tendrils", null, new MMap(1, new DimletType[]{DimletType.DIMLET_MATERIAL}), 2, 0),
    FEATURE_CANYONS("Canyons", null, new MMap(1, new DimletType[]{DimletType.DIMLET_MATERIAL}), 2, 0),
    FEATURE_MAZE("Maze", new TSet(new TerrainType[]{TerrainType.TERRAIN_AMPLIFIED, TerrainType.TERRAIN_FLAT, TerrainType.TERRAIN_NORMAL, TerrainType.TERRAIN_NEARLANDS}), null, 0, 0),
    FEATURE_LIQUIDORBS("LiquidOrbs", null, new MMap(-1, new DimletType[]{DimletType.DIMLET_MATERIAL, DimletType.DIMLET_LIQUID}), 1, 1),
    FEATURE_SHALLOW_OCEAN("ShallowOcean", new TSet(new TerrainType[]{TerrainType.TERRAIN_PLATEAUS, TerrainType.TERRAIN_ISLANDS, TerrainType.TERRAIN_ISLAND, TerrainType.TERRAIN_CHAOTIC}), new MMap(1, new DimletType[]{DimletType.DIMLET_LIQUID}), 0, 3),
    FEATURE_VOLCANOES("Volcanoes", null, null, 0, 0),
    FEATURE_DENSE_CAVES("DenseCaves", new TSet(new TerrainType[]{TerrainType.TERRAIN_AMPLIFIED, TerrainType.TERRAIN_CAVERN, TerrainType.TERRAIN_FLOODED_CAVERN, TerrainType.TERRAIN_CHAOTIC, TerrainType.TERRAIN_FLAT, TerrainType.TERRAIN_ISLAND, TerrainType.TERRAIN_ISLANDS, TerrainType.TERRAIN_LOW_CAVERN, TerrainType.TERRAIN_NORMAL, TerrainType.TERRAIN_PLATEAUS, TerrainType.TERRAIN_NEARLANDS, TerrainType.TERRAIN_SOLID, TerrainType.TERRAIN_WAVES, TerrainType.TERRAIN_FILLEDWAVES, TerrainType.TERRAIN_ROUGH}), null, 0, 0),
    FEATURE_HUGEORBS("HugeOrbs", null, new MMap(-1, new DimletType[]{DimletType.DIMLET_MATERIAL}), 2, 0),
    FEATURE_HUGELIQUIDORBS("HugeLiquidOrbs", null, new MMap(-1, new DimletType[]{DimletType.DIMLET_MATERIAL, DimletType.DIMLET_LIQUID}), 1, 2),
    FEATURE_NODIMLETBUILDINGS("NoDimletBuildings", null, null, 0, 0),
    FEATURE_PYRAMIDS("Pyramids", new TSet(new TerrainType[]{TerrainType.TERRAIN_AMPLIFIED, TerrainType.TERRAIN_CAVERN, TerrainType.TERRAIN_FLOODED_CAVERN, TerrainType.TERRAIN_FLAT, TerrainType.TERRAIN_CHAOTIC, TerrainType.TERRAIN_ISLAND, TerrainType.TERRAIN_ISLANDS, TerrainType.TERRAIN_LOW_CAVERN, TerrainType.TERRAIN_NEARLANDS, TerrainType.TERRAIN_NORMAL, TerrainType.TERRAIN_PLATEAUS, TerrainType.TERRAIN_SOLID, TerrainType.TERRAIN_WAVES, TerrainType.TERRAIN_FILLEDWAVES, TerrainType.TERRAIN_ROUGH}), new MMap(-1, new DimletType[]{DimletType.DIMLET_MATERIAL}), 1, 0),
    FEATURE_CLEAN("Clean", null, null, 0, 0),
    FEATURE_SCATTEREDORBS("ScatteredOrbs", null, new MMap(-1, new DimletType[]{DimletType.DIMLET_MATERIAL}), 1, 0),
    FEATURE_ORESAPLENTY("OresAPlenty", null, null, 0, 0);

    private final String id;
    private final Set<TerrainType> supportedTerrains;
    private final Map<DimletType, Integer> supportedModifiers;
    private final int materialClass;
    private final int liquidClass;
    private static final Map<String, FeatureType> FEATURE_TYPE_MAP;

    private FeatureType(String id, Set<TerrainType> terrainTypes, Map<DimletType, Integer> modifiers, int materialClass, int liquidClass) {
        this.id = id;
        this.supportedTerrains = terrainTypes == null ? Collections.emptySet() : new HashSet<TerrainType>(terrainTypes);
        this.supportedModifiers = modifiers == null ? Collections.emptyMap() : new HashMap<DimletType, Integer>(modifiers);
        this.materialClass = materialClass;
        this.liquidClass = liquidClass;
    }

    public boolean isTerrainSupported(TerrainType type) {
        return this.supportedTerrains.isEmpty() || this.supportedTerrains.contains((Object)type);
    }

    public String getId() {
        return this.id;
    }

    public boolean supportsAllTerrains() {
        return this.supportedTerrains.isEmpty();
    }

    public int getMaterialClass() {
        return this.materialClass;
    }

    public int getLiquidClass() {
        return this.liquidClass;
    }

    public Integer getSupportedModifierAmount(DimletType type) {
        return this.supportedModifiers.get((Object)type);
    }

    public static FeatureType getFeatureById(String id) {
        return FEATURE_TYPE_MAP.get(id);
    }

    static {
        FEATURE_TYPE_MAP = new HashMap<String, FeatureType>();
        for (FeatureType type : FeatureType.values()) {
            FEATURE_TYPE_MAP.put(type.getId(), type);
        }
    }

    private static class MMap
    extends HashMap<DimletType, Integer> {
        private MMap(int amount, DimletType ... dimletTypes) {
            for (DimletType type : dimletTypes) {
                this.put(type, amount);
            }
        }
    }

    private static class TSet
    extends HashSet<TerrainType> {
        private TSet(TerrainType ... terrainTypes) {
            for (TerrainType type : terrainTypes) {
                this.add(type);
            }
        }
    }
}

