/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.description;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mcjty.rftoolsdim.config.PowerConfiguration;
import mcjty.rftoolsdim.config.Settings;
import mcjty.rftoolsdim.dimensions.dimlets.DimletCosts;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.KnownDimletConfiguration;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletType;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DimensionDescriptor {
    private final String descriptionString;
    private final int rfCreateCost;
    private final int rfMaintainCost;
    private final int tickCost;
    private final long forcedSeed;

    public DimensionDescriptor(List<DimletKey> descriptors, long forcedSeed) {
        int rfMinimum;
        this.forcedSeed = forcedSeed;
        StringBuilder s = new StringBuilder();
        ArrayList<Pair<DimletKey, List<DimletKey>>> dimlets = new ArrayList<Pair<DimletKey, List<DimletKey>>>();
        ArrayList<DimletKey> currentModifiers = new ArrayList<DimletKey>();
        this.groupDimletsAndModifiers(descriptors, dimlets, currentModifiers);
        this.constructDescriptionStringNew(s, dimlets, currentModifiers);
        this.descriptionString = s.toString();
        this.tickCost = this.calculateTickCost(dimlets);
        this.rfCreateCost = this.calculateCreationRfCost(dimlets, currentModifiers, this.tickCost);
        int rf = this.calculateMaintenanceRfCost(dimlets);
        int rfGain = this.calculateBonus(dimlets);
        if (rfGain > 0 && (rf -= rf * rfGain / 100) < (rfMinimum = Math.max(10, rf * PowerConfiguration.minimumCostPercentage / 100))) {
            rf = rfMinimum;
        }
        this.rfMaintainCost = rf;
    }

    private void constructDescriptionStringNew(StringBuilder s, List<Pair<DimletKey, List<DimletKey>>> dimlets, List<DimletKey> currentModifiers) {
        s.append('@');
        boolean first = true;
        for (Pair<DimletKey, List<DimletKey>> dimletWithModifiers : dimlets) {
            DimletKey key = (DimletKey)dimletWithModifiers.getLeft();
            List mods = (List)dimletWithModifiers.getRight();
            if (mods != null) {
                for (DimletKey modifier : mods) {
                    if (!first) {
                        s.append(',');
                    }
                    first = false;
                    s.append('#').append(modifier);
                }
            }
            if (!first) {
                s.append(',');
            }
            first = false;
            s.append(key);
        }
        for (DimletKey modifier : currentModifiers) {
            if (s.length() > 0) {
                s.append(',');
            }
            s.append('?').append(modifier);
        }
    }

    private void groupDimletsAndModifiers(List<DimletKey> descriptors, List<Pair<DimletKey, List<DimletKey>>> dimlets, List<DimletKey> currentModifiers) {
        for (DimletKey key : descriptors) {
            DimletType type = key.getType();
            if (type.dimletType.isModifier()) {
                currentModifiers.add(key);
                continue;
            }
            ArrayList<DimletKey> modifiers = new ArrayList<DimletKey>();
            if (!currentModifiers.isEmpty()) {
                ArrayList<DimletKey> copy = new ArrayList<DimletKey>(currentModifiers);
                for (DimletKey modifier : copy) {
                    if (!type.dimletType.isModifiedBy(modifier.getType())) continue;
                    modifiers.add(modifier);
                    currentModifiers.remove(modifier);
                }
            }
            dimlets.add((Pair<DimletKey, List<DimletKey>>)Pair.of((Object)key, modifiers));
        }
    }

    public DimensionDescriptor(NBTTagCompound tagCompound) {
        this.descriptionString = tagCompound.func_74779_i("descriptionString");
        this.rfCreateCost = tagCompound.func_74762_e("rfCreateCost");
        this.rfMaintainCost = tagCompound.func_74762_e("rfMaintainCost");
        this.tickCost = tagCompound.func_74762_e("tickCost");
        this.forcedSeed = tagCompound.func_74763_f("forcedSeed");
    }

    public List<Pair<DimletKey, List<DimletKey>>> getDimletsWithModifiers() {
        ArrayList<Pair<DimletKey, List<DimletKey>>> result = new ArrayList<Pair<DimletKey, List<DimletKey>>>();
        String ds = this.descriptionString;
        if (ds.startsWith("@")) {
            ds = ds.substring(1);
        }
        if (!ds.isEmpty()) {
            String[] opcodes;
            ArrayList<DimletKey> modifiers = new ArrayList<DimletKey>();
            for (String oc : opcodes = StringUtils.split((String)ds, (String)",")) {
                DimletKey key;
                if (oc.startsWith("#")) {
                    key = DimletKey.parseKey(oc.substring(1));
                    modifiers.add(key);
                    continue;
                }
                if (oc.startsWith("?")) continue;
                key = DimletKey.parseKey(oc);
                result.add((Pair<DimletKey, List<DimletKey>>)Pair.of((Object)key, modifiers));
                modifiers = new ArrayList();
            }
        }
        return result;
    }

    public static List<DimletKey> parseDescriptionString(String descriptionString) {
        if (descriptionString == null || descriptionString.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DimletKey> result = new ArrayList<DimletKey>();
        String ds = descriptionString.substring(1);
        if (!ds.isEmpty()) {
            String[] opcodes;
            for (String oc : opcodes = StringUtils.split((String)ds, (String)",")) {
                DimletKey key = oc.startsWith("#") ? DimletKey.parseKey(oc.substring(1)) : (oc.startsWith("?") ? DimletKey.parseKey(oc.substring(1)) : DimletKey.parseKey(oc));
                result.add(key);
            }
        }
        return result;
    }

    public long calculateSeed(long seed) {
        List<DimletKey> dimletDescriptors = DimensionDescriptor.parseDescriptionString(this.descriptionString);
        for (DimletKey key : dimletDescriptors) {
            if (key.getId() == null) continue;
            seed = 31L * seed + (long)key.getId().hashCode();
        }
        return seed;
    }

    public String getDescriptionString() {
        return this.descriptionString;
    }

    public int getRfCreateCost() {
        return this.rfCreateCost;
    }

    public int getRfMaintainCost() {
        return this.rfMaintainCost;
    }

    public int getTickCost() {
        return this.tickCost;
    }

    public long getForcedSeed() {
        return this.forcedSeed;
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("descriptionString", this.descriptionString);
        tagCompound.func_74768_a("rfCreateCost", this.rfCreateCost);
        tagCompound.func_74768_a("rfMaintainCost", this.rfMaintainCost);
        tagCompound.func_74768_a("tickCost", this.tickCost);
        tagCompound.func_74768_a("ticksLeft", this.tickCost);
        tagCompound.func_74772_a("forcedSeed", this.forcedSeed);
    }

    private int getModifierMultiplier(Map<Pair<DimletType, DimletType>, Integer> modifierMap, DimletType type1, DimletType type2) {
        Integer multiplier = modifierMap.get(Pair.of((Object)((Object)type1), (Object)((Object)type2)));
        if (multiplier == null) {
            return 1;
        }
        return multiplier;
    }

    private int getCreationCost(DimletType type, DimletKey key) {
        int cost = 0;
        Settings settings = KnownDimletConfiguration.getSettings(key);
        if (settings != null) {
            cost = settings.getCreateCost();
        }
        return cost;
    }

    private int calculateCreationRfCost(List<Pair<DimletKey, List<DimletKey>>> dimlets, List<DimletKey> unusedModifiers, int tickCost) {
        int rf = DimletCosts.baseDimensionCreationCost;
        for (Pair<DimletKey, List<DimletKey>> dimletWithModifier : dimlets) {
            DimletKey key = (DimletKey)dimletWithModifier.getLeft();
            DimletType type = key.getType();
            List list = (List)dimletWithModifier.getRight();
            if (list != null) {
                for (DimletKey modifier : list) {
                    float mult = type.dimletType.getModifierCreateCostFactor(modifier.getType(), key);
                    rf += (int)((float)this.getCreationCost(modifier.getType(), modifier) * mult);
                }
            }
            rf += this.getCreationCost(type, key);
        }
        for (DimletKey modifier : unusedModifiers) {
            rf += this.getCreationCost(modifier.getType(), modifier);
        }
        return rf;
    }

    private int getMaintenanceCost(DimletType type, DimletKey key) {
        int cost = 0;
        Settings settings = KnownDimletConfiguration.getSettings(key);
        if (settings != null) {
            cost = settings.getMaintainCost();
        }
        return cost;
    }

    public int calculateNominalCost() {
        List<DimletKey> dimletKeys = DimensionDescriptor.parseDescriptionString(this.descriptionString);
        ArrayList<Pair<DimletKey, List<DimletKey>>> dimlets = new ArrayList<Pair<DimletKey, List<DimletKey>>>();
        ArrayList<DimletKey> currentModifiers = new ArrayList<DimletKey>();
        this.groupDimletsAndModifiers(dimletKeys, dimlets, currentModifiers);
        return this.calculateMaintenanceRfCost(dimlets);
    }

    private int calculateMaintenanceRfCost(List<Pair<DimletKey, List<DimletKey>>> dimlets) {
        int rf = DimletCosts.baseDimensionMaintenanceCost;
        for (Pair<DimletKey, List<DimletKey>> dimletWithModifier : dimlets) {
            int c;
            DimletKey key = (DimletKey)dimletWithModifier.getLeft();
            DimletType type = key.getType();
            List list = (List)dimletWithModifier.getRight();
            if (list != null) {
                for (DimletKey modifier : list) {
                    float mult = type.dimletType.getModifierMaintainCostFactor(modifier.getType(), key);
                    rf += (int)((float)this.getMaintenanceCost(modifier.getType(), modifier) * mult);
                }
            }
            if ((c = this.getMaintenanceCost(type, key)) <= 0) continue;
            rf += c;
        }
        return rf;
    }

    private int calculateBonus(List<Pair<DimletKey, List<DimletKey>>> dimlets) {
        int rfGain = 0;
        for (Pair<DimletKey, List<DimletKey>> dimletWithModifier : dimlets) {
            DimletKey key = (DimletKey)dimletWithModifier.getLeft();
            DimletType type = key.getType();
            int c = this.getMaintenanceCost(type, key);
            if (c >= 0) continue;
            rfGain -= c;
        }
        return rfGain;
    }

    private int getTickCost(DimletType type, DimletKey key) {
        int cost = 0;
        Settings settings = KnownDimletConfiguration.getSettings(key);
        if (settings != null) {
            cost = settings.getTickCost();
        }
        return cost;
    }

    private int calculateTickCost(List<Pair<DimletKey, List<DimletKey>>> dimlets) {
        int ticks = DimletCosts.baseDimensionTickCost;
        for (Pair<DimletKey, List<DimletKey>> dimletWithModifier : dimlets) {
            DimletKey key = (DimletKey)dimletWithModifier.getLeft();
            DimletType type = key.getType();
            List list = (List)dimletWithModifier.getRight();
            if (list != null) {
                for (DimletKey modifier : list) {
                    float mult = type.dimletType.getModifierTickCostFactor(modifier.getType(), key);
                    ticks += (int)((float)this.getTickCost(modifier.getType(), modifier) * mult);
                }
            }
            ticks += this.getTickCost(type, key);
        }
        return ticks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionDescriptor that = (DimensionDescriptor)o;
        return this.descriptionString.equals(that.descriptionString);
    }

    public int hashCode() {
        return this.descriptionString.hashCode();
    }
}

