/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.rftoolsdim.config.PowerConfiguration;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class DimensionStorage
extends AbstractWorldData<DimensionStorage> {
    private static final String DIMSTORAGE_NAME = "RFToolsDimensionStorage";
    private final Map<Integer, Long> energy = new HashMap<Integer, Long>();
    private static DimensionStorage clientInstance = null;

    public DimensionStorage(String name) {
        super(name);
    }

    public void clear() {
        this.energy.clear();
    }

    public static DimensionStorage getDimensionStorage(World world) {
        if (world.field_72995_K) {
            if (clientInstance == null) {
                clientInstance = new DimensionStorage(DIMSTORAGE_NAME);
            }
            return clientInstance;
        }
        return (DimensionStorage)DimensionStorage.getData((World)world, DimensionStorage.class, (String)DIMSTORAGE_NAME);
    }

    public long getEnergyLevel(int id) {
        if (this.energy.containsKey(id)) {
            return this.energy.get(id);
        }
        return 0L;
    }

    public void setEnergyLevel(int id, long energyLevel) {
        WorldServer world;
        long old = this.getEnergyLevel(id);
        this.energy.put(id, energyLevel);
        if (PowerConfiguration.freezeUnpowered && (world = DimensionManager.getWorld((int)id)) != null) {
            if (old == 0L && energyLevel > 0L) {
                RfToolsDimensionManager.unfreezeDimension((World)world);
            } else if (energyLevel == 0L) {
                RfToolsDimensionManager.freezeDimension((World)world);
            }
        }
    }

    public void removeDimension(int id) {
        this.energy.remove(id);
    }

    public void func_76184_a(NBTTagCompound tagCompound) {
        this.energy.clear();
        NBTTagList lst = tagCompound.func_150295_c("dimensions", 10);
        for (int i = 0; i < lst.func_74745_c(); ++i) {
            NBTTagCompound tc = lst.func_150305_b(i);
            int id = tc.func_74762_e("id");
            long rf = tc.func_74763_f("energy");
            this.energy.put(id, rf);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tagCompound) {
        NBTTagList lst = new NBTTagList();
        for (Map.Entry<Integer, Long> me : this.energy.entrySet()) {
            NBTTagCompound tc = new NBTTagCompound();
            tc.func_74768_a("id", me.getKey().intValue());
            tc.func_74772_a("energy", me.getValue().longValue());
            lst.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("dimensions", (NBTBase)lst);
        return tagCompound;
    }
}

