/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.world;

import com.google.common.collect.Sets;
import elec332.core.ElecCore;
import elec332.core.api.structure.GenerationType;
import elec332.core.api.structure.ISchematic;
import elec332.core.api.util.Area;
import elec332.core.world.WorldHelper;
import elec332.core.world.schematic.Schematic;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class StructureTemplate {
    protected Schematic schematic;
    protected Set<Integer> dimensions;
    protected GenerationType generationType;

    public StructureTemplate(Schematic schematic, GenerationType generationType, Integer ... dimensions) {
        this.schematic = schematic;
        this.generationType = generationType;
        this.dimensions = Sets.newHashSet((Object[])dimensions);
    }

    public StructureTemplate(Schematic schematic, Integer ... dimensions) {
        this(schematic, GenerationType.NONE, dimensions);
    }

    public void generateStructure(BlockPos location, World world) {
        if (!world.field_72995_K) {
            int chunkZ;
            int chunkX;
            int xCoord = location.func_177958_n();
            int yCoord = location.func_177956_o();
            int zCoord = location.func_177952_p();
            switch (this.generationType) {
                case SEA_LEVEL: {
                    yCoord = 62;
                    break;
                }
                case UNDERGROUND: {
                    yCoord = 16;
                    break;
                }
                case SURFACE: {
                    yCoord = world.func_175672_r(location).func_177956_o();
                    break;
                }
            }
            if (!this.canSpawnInDimension(WorldHelper.getDimID(world))) {
                ElecCore.logger.info("Error, structure attempting to generate in invalid dimension!");
                return;
            }
            ISchematic schematic = this.getSchematic();
            Area schematicArea = schematic.getAreaFromWorldCoordinates(xCoord, yCoord, zCoord);
            if (schematicArea.doAreasIntersect(new Area((chunkX = location.func_177958_n() >> 4) << 4, 0, (chunkZ = location.func_177952_p() >> 4) << 4, (chunkX << 4) + 16, 255, (chunkZ << 4) + 16))) {
                for (int x = 0; x < schematic.getBlockWidth(); ++x) {
                    for (int y = 0; y < schematic.getBlockHeight(); ++y) {
                        for (int z = 0; z < schematic.getBlockLength(); ++z) {
                            NBTTagCompound tileData;
                            int worldX = xCoord + x;
                            int worldY = yCoord + y;
                            int worldZ = zCoord + z;
                            BlockPos schematicPos = new BlockPos(x, y, z);
                            BlockPos worldPos = new BlockPos(worldX, worldY, worldZ);
                            Block block = schematic.getBlock(schematicPos);
                            IBlockState state = schematic.getBlockState(schematicPos);
                            if (block == null) continue;
                            WorldHelper.setBlockState(world, worldPos, Blocks.field_150350_a.func_176223_P(), 2);
                            if (block.isAir(state, (IBlockAccess)world, worldPos)) continue;
                            WorldHelper.setBlockState(world, worldPos, state, 2);
                            if (!block.hasTileEntity(state) || (tileData = schematic.getTileData(x, y, z, worldX, worldY, worldZ)) == null) continue;
                            WorldHelper.getTileAt((IBlockAccess)world, worldPos).func_145839_a(tileData);
                            WorldHelper.markBlockForUpdate(world, worldPos);
                        }
                    }
                }
                for (int i = chunkX; i < chunkX + (schematicArea.getBlockWidth() >> 4); ++i) {
                    for (int j = chunkZ; j < chunkZ + (schematicArea.getBlockLength() >> 4); ++j) {
                        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
                        chunk.func_177427_f(true);
                        chunk.func_76594_o();
                    }
                }
            }
        }
    }

    public ISchematic getSchematic() {
        return this.schematic;
    }

    public GenerationType getGenerationType() {
        return this.generationType;
    }

    public Set<Integer> getDimensions() {
        return this.dimensions;
    }

    public boolean isDimensionRestricted() {
        return this.getDimensions() != null && !this.getDimensions().isEmpty();
    }

    public boolean canSpawnInDimension(int dimension) {
        return !this.isDimensionRestricted() || this.getDimensions().contains(dimension);
    }
}

