/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import com.google.common.collect.BiMap;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

public class RegistryHelper {
    public static <T> void registerEmptyCapability(Class<T> clazz) {
        CapabilityManager.INSTANCE.register(clazz, new Capability.IStorage<T>(){

            public NBTBase writeNBT(Capability capability, Object instance, EnumFacing side) {
                throw new UnsupportedOperationException();
            }

            public void readNBT(Capability capability, Object instance, EnumFacing side, NBTBase nbt) {
                throw new UnsupportedOperationException();
            }
        }, () -> {
            throw new UnsupportedOperationException();
        });
    }

    public static <T extends IForgeRegistryEntry<T>, C extends IForgeRegistry.AddCallback<T> & IForgeRegistry.ClearCallback<T>> ForgeRegistry<T> createRegistry(ResourceLocation registryName, Class<T> registryType, C callback) {
        return RegistryHelper.createRegistry(registryName, registryType, 0, 127, callback);
    }

    public static <T extends IForgeRegistryEntry<T>, C extends IForgeRegistry.AddCallback<T> & IForgeRegistry.ClearCallback<T>> ForgeRegistry<T> createRegistry(ResourceLocation registryName, Class<T> registryType, int minId, int maxId, C callback) {
        return (ForgeRegistry)new RegistryBuilder().setName(registryName).addCallback(callback).setType(registryType).setIDRange(minId, maxId).create();
    }

    public static ForgeRegistry<Block> getBlockRegistry() {
        return (ForgeRegistry)ForgeRegistries.BLOCKS;
    }

    public static ForgeRegistry<Item> getItemRegistry() {
        return (ForgeRegistry)ForgeRegistries.ITEMS;
    }

    public static ForgeRegistry<Potion> getPotionRegistry() {
        return (ForgeRegistry)ForgeRegistries.POTIONS;
    }

    public static ForgeRegistry<Biome> getBiomeRegistry() {
        return (ForgeRegistry)ForgeRegistries.BIOMES;
    }

    public static ForgeRegistry<SoundEvent> getSoundEventRegistry() {
        return (ForgeRegistry)ForgeRegistries.SOUND_EVENTS;
    }

    public static ForgeRegistry<PotionType> getPotionTypesRegistry() {
        return (ForgeRegistry)ForgeRegistries.POTION_TYPES;
    }

    public static ForgeRegistry<Enchantment> getEnchantmentRegistry() {
        return (ForgeRegistry)ForgeRegistries.ENCHANTMENTS;
    }

    public static ForgeRegistry<VillagerRegistry.VillagerProfession> getVillagerRegistry() {
        return (ForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS;
    }

    public static ForgeRegistry<IRecipe> getRecipes() {
        return (ForgeRegistry)ForgeRegistries.RECIPES;
    }

    public static ForgeRegistry<EntityEntry> getEntities() {
        return (ForgeRegistry)ForgeRegistries.ENTITIES;
    }

    public static BiMap<Block, Item> getBlockItemMap() {
        return GameData.getBlockItemMap();
    }

    public static interface FullRegistryCallback<T extends IForgeRegistryEntry<T>>
    extends IForgeRegistry.AddCallback<T>,
    IForgeRegistry.ClearCallback<T>,
    IForgeRegistry.CreateCallback<T>,
    IForgeRegistry.ValidateCallback<T> {
    }
}

