/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.api.module;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import elec332.core.api.module.IModuleController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionParser;

public interface IModuleInfo {
    @Nonnull
    public String getOwner();

    @Nonnull
    public String getName();

    @Nonnull
    public ResourceLocation getCombinedName();

    public boolean autoDisableIfRequirementsNotMet();

    @Nonnull
    public List<ArtifactVersion> getModDependencies();

    @Nonnull
    public List<String> getModuleDependencies();

    @Nonnull
    public String getModuleClass();

    public boolean alwaysEnabled();

    @Nonnull
    public IModuleController getModuleController();

    public static List<ArtifactVersion> parseDependencyInfo(String modDependencies) {
        String[] parts;
        ArrayList ret = Lists.newArrayList();
        if (Strings.isNullOrEmpty((String)modDependencies)) {
            return ImmutableList.of();
        }
        for (String s : parts = modDependencies.split(";")) {
            ret.add(VersionParser.parseVersionReference((String)s));
        }
        return ImmutableList.copyOf((Collection)ret);
    }
}

