/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.thermalexpansion;

import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.item.ItemMorb;
import cofh.thermalexpansion.util.managers.machine.CentrifugeManager;
import cofh.thermalfoundation.init.TFFluids;
import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.WeightedItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.thermalexpansion.Centrifuge")
@ModOnly(value="thermalexpansion")
@ZenRegister
public class Centrifuge {
    @ZenMethod
    public static void addRecipe(WeightedItemStack[] outputs, IItemStack input, ILiquidStack fluid, int energy) {
        IItemStack[] items = new IItemStack[outputs.length];
        Integer[] chances = new Integer[outputs.length];
        for (int i = 0; i < outputs.length; ++i) {
            items[i] = outputs[i].getStack();
            chances[i] = (int)outputs[i].getPercent();
        }
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toStacks((IItemStack[])items), chances, InputHelper.toStack((IItemStack)input), energy, InputHelper.toFluid((ILiquidStack)fluid)));
    }

    @ZenMethod
    public static void addRecipeMob(String entityId, WeightedItemStack[] outputs, ILiquidStack fluid, int energy, int xp) {
        IItemStack[] items = new IItemStack[outputs.length];
        Integer[] chances = new Integer[outputs.length];
        if (energy <= 0) {
            energy = 4000;
        }
        for (int i = 0; i < outputs.length; ++i) {
            items[i] = outputs[i].getStack();
            chances[i] = (int)outputs[i].getPercent();
        }
        ModTweaker.LATE_ADDITIONS.add((IAction)new AddMob(InputHelper.toStacks((IItemStack[])items), chances, entityId, energy, InputHelper.toFluid((ILiquidStack)fluid), xp));
    }

    @ZenMethod
    public static void addRecipeMob(IEntityDefinition entity, WeightedItemStack[] outputs, ILiquidStack fluid, int energy, int xp) {
        Centrifuge.addRecipeMob(entity.getId(), outputs, fluid, energy, xp);
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(InputHelper.toStack((IItemStack)input)));
    }

    @ZenMethod
    public static void removeRecipeMob(String entityId) {
        ModTweaker.LATE_REMOVALS.add((IAction)new RemoveMob(entityId));
    }

    @ZenMethod
    public static void removeRecipeMob(IEntityDefinition entity) {
        ModTweaker.LATE_REMOVALS.add((IAction)new RemoveMob(entity.getId()));
    }

    private static class RemoveMob
    extends BaseAction {
        private String entityId;

        public RemoveMob(String entityId) {
            super("Centrifuge");
            this.entityId = entityId;
        }

        public void apply() {
            ItemStack standard = ItemMorb.setTag((ItemStack)ItemHelper.cloneStack((ItemStack)ItemMorb.morbStandard), (String)this.entityId, (boolean)false);
            ItemStack reusable = ItemMorb.setTag((ItemStack)ItemHelper.cloneStack((ItemStack)ItemMorb.morbReusable), (String)this.entityId, (boolean)false);
            if (!CentrifugeManager.recipeExistsMob((ItemStack)standard) && !CentrifugeManager.recipeExistsMob((ItemStack)reusable)) {
                CraftTweakerAPI.logError((String)("No Centrifuge mob recipe exists for entity: " + this.entityId));
                return;
            }
            if (CentrifugeManager.recipeExistsMob((ItemStack)standard)) {
                CentrifugeManager.removeRecipeMob((ItemStack)standard);
            }
            if (CentrifugeManager.recipeExistsMob((ItemStack)reusable)) {
                CentrifugeManager.removeRecipeMob((ItemStack)reusable);
            }
        }

        protected String getRecipeInfo() {
            return this.entityId;
        }
    }

    private static class Remove
    extends BaseAction {
        private ItemStack input;

        public Remove(ItemStack input) {
            super("Centrifuge");
            this.input = input;
        }

        public void apply() {
            if (!CentrifugeManager.recipeExists((ItemStack)this.input)) {
                CraftTweakerAPI.logError((String)("No Centrifuge recipe exists for: " + this.input));
                return;
            }
            CentrifugeManager.removeRecipe((ItemStack)this.input);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.input);
        }
    }

    private static class AddMob
    extends BaseAction {
        private ItemStack[] outputs;
        private Integer[] chances;
        private String entityId;
        private int energy;
        private FluidStack fluid;
        private int xp;

        public AddMob(ItemStack[] outputs, Integer[] chances, String entityId, int energy, FluidStack fluid, int xp) {
            super("Centrifuge");
            this.outputs = outputs;
            this.chances = chances;
            this.entityId = entityId;
            this.energy = energy;
            this.fluid = fluid;
            this.xp = xp;
        }

        public void apply() {
            if (!ItemMorb.validMobs.contains(this.entityId)) {
                CraftTweakerAPI.logError((String)("Not a valid morb entity: " + this.entityId));
                return;
            }
            if (this.fluid == null) {
                this.fluid = new FluidStack(TFFluids.fluidExperience, this.xp * 20);
            }
            ArrayList<ItemStack> outputStandard = new ArrayList<ItemStack>(Arrays.asList(this.outputs));
            ArrayList<ItemStack> outputReusable = new ArrayList<ItemStack>(Arrays.asList(this.outputs));
            ArrayList<Integer> chanceStandard = new ArrayList<Integer>(Arrays.asList(this.chances));
            ArrayList<Integer> chanceReusable = new ArrayList<Integer>(Arrays.asList(this.chances));
            outputStandard.add(ItemHelper.cloneStack((ItemStack)ItemMorb.morbStandard));
            outputReusable.add(ItemHelper.cloneStack((ItemStack)ItemMorb.morbReusable));
            chanceStandard.add(25);
            chanceReusable.add(100);
            CentrifugeManager.addRecipeMob((int)this.energy, (ItemStack)ItemMorb.setTag((ItemStack)ItemHelper.cloneStack((ItemStack)ItemMorb.morbStandard), (String)this.entityId, (boolean)false), outputStandard, chanceStandard, (FluidStack)this.fluid);
            CentrifugeManager.addRecipeMob((int)this.energy, (ItemStack)ItemMorb.setTag((ItemStack)ItemHelper.cloneStack((ItemStack)ItemMorb.morbReusable), (String)this.entityId, (boolean)false), outputReusable, chanceReusable, (FluidStack)this.fluid);
        }

        protected String getRecipeInfo() {
            return this.entityId;
        }
    }

    private static class Add
    extends BaseAction {
        private ItemStack[] outputs;
        private Integer[] chances;
        private ItemStack input;
        private int energy;
        private FluidStack fluid;

        public Add(ItemStack[] outputs, Integer[] chances, ItemStack input, int energy, FluidStack fluid) {
            super("Centrifuge");
            this.outputs = outputs;
            this.chances = chances;
            this.input = input;
            this.energy = energy;
            this.fluid = fluid;
        }

        public void apply() {
            CentrifugeManager.addRecipe((int)this.energy, (ItemStack)this.input, Arrays.asList(this.outputs), Arrays.asList(this.chances), (FluidStack)this.fluid);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.input);
        }
    }
}

