/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.melee.item;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;

public class BattleAxe
extends AoeToolCore {
    public BattleAxe() {
        super(PartMaterialType.handle(TinkerTools.toughToolRod), PartMaterialType.head(TinkerTools.broadAxeHead), PartMaterialType.head(TinkerTools.broadAxeHead), PartMaterialType.extra(TinkerTools.toughBinding));
        this.addCategory(Category.WEAPON);
        this.setHarvestLevel("axe", 0);
    }

    @Override
    public ImmutableList<BlockPos> getAOEBlocks(ItemStack stack, World world, EntityPlayer player, BlockPos origin) {
        return ToolHelper.calcAOEBlocks(stack, world, player, origin, 2, 2, 1);
    }

    @Override
    public float damagePotential() {
        return 2.0f;
    }

    @Override
    public float damageCutoff() {
        return 30.0f;
    }

    @Override
    public double attackSpeed() {
        return 1.0;
    }

    @Override
    public int[] getRepairParts() {
        return new int[]{1, 2};
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.FAIL;
    }

    @Override
    public ToolNBT buildTagData(List<Material> materials) {
        HeadMaterialStats handle = (HeadMaterialStats)materials.get(0).getStats("head");
        HeadMaterialStats head1 = (HeadMaterialStats)materials.get(1).getStats("head");
        HeadMaterialStats head2 = (HeadMaterialStats)materials.get(2).getStats("head");
        HeadMaterialStats binding = (HeadMaterialStats)materials.get(3).getStats("head");
        ToolNBT data = new ToolNBT();
        data.harvestLevel = Math.max(head1.harvestLevel, head2.harvestLevel);
        data.durability = (head1.durability + head2.durability) / 2;
        data.speed *= 0.5f;
        data.attack = (head1.attack + head2.attack) * 3.0f / 2.0f;
        return data;
    }
}

