/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import gnu.trove.map.hash.THashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import slimeknights.mantle.client.model.BakedWrapper;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;

public class BakedMaterialModel
extends BakedWrapper.Perspective
implements IBakedModel {
    protected Map<String, IBakedModel> parts = new THashMap(TinkerRegistry.getAllMaterials().size());

    public BakedMaterialModel(IBakedModel base, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
        super(base, transforms);
    }

    public void addMaterialModel(Material material, IBakedModel model) {
        this.parts.put(material.identifier, model);
    }

    public IBakedModel getModelByIdentifier(String identifier) {
        IBakedModel materialModel = this.parts.get(identifier);
        if (materialModel == null) {
            return this;
        }
        return materialModel;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return MaterialItemOverrideList.INSTANCE;
    }

    private static class MaterialItemOverrideList
    extends ItemOverrideList {
        static MaterialItemOverrideList INSTANCE = new MaterialItemOverrideList();

        private MaterialItemOverrideList() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            String id = ((IMaterialItem)stack.func_77973_b()).getMaterialID(stack);
            return ((BakedMaterialModel)originalModel).getModelByIdentifier(id);
        }
    }
}

