/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.item;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.client.gui.GuiElement;
import slimeknights.mantle.item.ItemArmorTooltip;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.capability.piggyback.CapabilityTinkerPiggyback;
import slimeknights.tconstruct.library.capability.piggyback.ITinkerPiggyback;
import slimeknights.tconstruct.library.capability.piggyback.TinkerPiggybackSerializer;
import slimeknights.tconstruct.library.client.Icons;
import slimeknights.tconstruct.library.potion.TinkerPotion;

public class ItemPiggybackPack
extends ItemArmorTooltip {
    private static final int MAX_ENTITY_STACK = 3;
    public static ItemArmor.ArmorMaterial PIGGYBACK_MATERIAL = EnumHelper.addArmorMaterial((String)"PIGGYBACK", (String)Util.resource("piggyback"), (int)0, (int[])new int[]{0, 0, 0, 0}, (int)0, (SoundEvent)SoundEvents.field_187884_fr, (float)0.0f);

    public ItemPiggybackPack() {
        super(PIGGYBACK_MATERIAL, 0, EntityEquipmentSlot.CHEST);
        this.func_77625_d(16);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        ItemStack chestArmor = playerIn.func_184582_a(this.field_77881_a);
        if (chestArmor.func_77973_b() != this && playerIn.field_71071_by.func_70447_i() == -1) {
            return false;
        }
        if (this.pickupEntity(playerIn, (Entity)target)) {
            if (chestArmor.func_77973_b() != this) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)chestArmor);
                chestArmor = ItemStack.field_190927_a;
            }
            if (chestArmor.func_190926_b()) {
                playerIn.func_184201_a(this.field_77881_a, stack.func_77979_a(1));
            } else if (chestArmor.func_190916_E() < this.getEntitiesCarriedCount((EntityLivingBase)playerIn)) {
                stack.func_77979_a(1);
                chestArmor.func_190917_f(1);
            }
            return true;
        }
        return false;
    }

    public boolean pickupEntity(EntityPlayer player, Entity target) {
        int count;
        if (player.func_130014_f_().field_72995_K) {
            return false;
        }
        if (target.func_184187_bx() == player || player.func_184187_bx() == target) {
            return false;
        }
        EntityPlayer toRide = player;
        for (count = 0; toRide.func_184207_aI() && count < 3; ++count) {
            toRide = (Entity)toRide.func_184188_bt().get(0);
            if (!(toRide instanceof EntityPlayer) || !(target instanceof EntityPlayer)) continue;
            return false;
        }
        if (!toRide.func_184207_aI() && count < 3 && target.func_184205_a((Entity)toRide, true)) {
            if (player instanceof EntityPlayerMP) {
                TinkerNetwork.sendPacket((Entity)player, new SPacketSetPassengers((Entity)player));
            }
            return true;
        }
        return false;
    }

    public int getEntitiesCarriedCount(EntityLivingBase player) {
        int count = 0;
        EntityLivingBase ridden = player;
        while (ridden.func_184207_aI()) {
            ++count;
            ridden = (Entity)ridden.func_184188_bt().get(0);
        }
        return count;
    }

    public void matchCarriedEntitiesToCount(EntityLivingBase player, int maxCount) {
        int count = 0;
        EntityLivingBase ridden = player;
        while (ridden.func_184207_aI()) {
            ridden = (Entity)ridden.func_184188_bt().get(0);
            if (++count <= maxCount) continue;
            ridden.func_184210_p();
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        EntityLivingBase entityLivingBase;
        if (entityIn instanceof EntityLivingBase && (entityLivingBase = (EntityLivingBase)entityIn).func_184582_a(EntityEquipmentSlot.CHEST) == stack && entityIn.func_184207_aI()) {
            int amplifier = this.getEntitiesCarriedCount(entityLivingBase) - 1;
            entityLivingBase.func_70690_d(new PotionEffect((Potion)CarryPotionEffect.INSTANCE, 1, amplifier, true, false));
        }
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(Util.getResource("piggyback"), (ICapabilityProvider)new TinkerPiggybackSerializer((EntityPlayer)event.getObject()));
        }
    }

    public static class CarryPotionEffect
    extends TinkerPotion {
        public static final CarryPotionEffect INSTANCE = new CarryPotionEffect();
        public static final String UUID = "ff4de63a-2b24-11e6-b67b-9e71128cae77";

        protected CarryPotionEffect() {
            super(Util.getResource("carry"), false, true);
            this.func_111184_a(SharedMonsterAttributes.field_111263_d, UUID, -0.05, 2);
        }

        public boolean func_76397_a(int duration, int amplifier) {
            return true;
        }

        public void func_76394_a(@Nonnull EntityLivingBase entityLivingBaseIn, int p_76394_2_) {
            ItemStack chestArmor = entityLivingBaseIn.func_184582_a(EntityEquipmentSlot.CHEST);
            if (chestArmor.func_190926_b()) {
                TinkerGadgets.piggybackPack.matchCarriedEntitiesToCount(entityLivingBaseIn, 0);
            } else if (chestArmor.func_77973_b() == TinkerGadgets.piggybackPack) {
                TinkerGadgets.piggybackPack.matchCarriedEntitiesToCount(entityLivingBaseIn, chestArmor.func_190916_E());
                if (!entityLivingBaseIn.func_130014_f_().field_72995_K && entityLivingBaseIn.hasCapability(CapabilityTinkerPiggyback.PIGGYBACK, null)) {
                    ITinkerPiggyback piggyback = (ITinkerPiggyback)entityLivingBaseIn.getCapability(CapabilityTinkerPiggyback.PIGGYBACK, null);
                    piggyback.updatePassengers();
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void renderInventoryEffect(int x, int y, PotionEffect effect, Minecraft mc) {
            this.renderHUDEffect(x, y, effect, mc, 1.0f);
        }

        @SideOnly(value=Side.CLIENT)
        public void renderHUDEffect(int x, int y, PotionEffect effect, Minecraft mc, float alpha) {
            GuiElement element;
            mc.func_110434_K().func_110577_a(Icons.ICON);
            switch (effect.func_76458_c()) {
                case 0: {
                    element = Icons.ICON_PIGGYBACK_1;
                    break;
                }
                case 1: {
                    element = Icons.ICON_PIGGYBACK_2;
                    break;
                }
                case 2: {
                    element = Icons.ICON_PIGGYBACK_3;
                    break;
                }
                default: {
                    element = Icons.ICON_PIGGYBACK_3;
                }
            }
            element.draw(x + 6, y + 7);
        }
    }
}

