/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import cpw.mods.inventorysorter.Action;
import cpw.mods.inventorysorter.InventorySorter;
import cpw.mods.inventorysorter.KeyHandler;
import java.io.File;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SideProxy {
    @SidedProxy(clientSide="cpw.mods.inventorysorter.SideProxy$ClientProxy", serverSide="cpw.mods.inventorysorter.SideProxy")
    static SideProxy INSTANCE;
    Property containerDebug;
    Property containerBlacklist;
    private Configuration configuration;

    public void bindKeys() {
    }

    protected void doConfiguration(File suggestedConfigurationFile, Consumer<Configuration> thingsToDo) {
        if (this.configuration == null) {
            this.configuration = new Configuration(suggestedConfigurationFile);
        }
        thingsToDo.accept(this.configuration);
        if (this.configuration.hasChanged()) {
            this.configuration.save();
        }
    }

    protected Consumer<Configuration> blackList() {
        return c -> {
            this.containerBlacklist = c.get("general", "containerBlacklist", new String[0]);
            for (String blacklisted : this.containerBlacklist.getStringList()) {
                FMLInterModComms.sendMessage((String)"inventorysorter", (String)"containerblacklist", (String)blacklisted);
            }
            this.containerDebug = c.get("general", "containerDebug", false);
            this.containerDebug.setLanguageKey("inventorysorter.gui.containerDebug");
            this.containerDebug.setRequiresMcRestart(false);
            this.containerDebug.setRequiresWorldRestart(false);
            InventorySorter.INSTANCE.debugLog = this.containerDebug.getBoolean(false);
        };
    }

    public void loadConfiguration(File suggestedConfigurationFile) {
        this.doConfiguration(suggestedConfigurationFile, this.blackList());
    }

    public void updateConfiguration(Set<String> cbl) {
        this.containerBlacklist.set(cbl.toArray(new String[cbl.size()]));
        this.configuration.save();
    }

    public static class ClientProxy
    extends SideProxy {
        @Override
        public void bindKeys() {
            MinecraftForge.EVENT_BUS.register((Object)new KeyHandler());
        }

        @Override
        public void loadConfiguration(final File suggestedConfigurationFile) {
            this.doConfiguration(suggestedConfigurationFile, this.blackList().andThen(Action::configure));
            MinecraftForge.EVENT_BUS.register(new Object(){

                @SubscribeEvent
                public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent evt) {
                    if (!"inventorysorter".equals(evt.getModID())) {
                        return;
                    }
                    this.doConfiguration(suggestedConfigurationFile, this.blackList().andThen(Action::configure));
                }
            });
        }
    }
}

