/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.client.models;

import aroma1997.core.client.models.IRenderableModel;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.item.ItemStack;

public class CustomModelRenderer
extends TileEntityItemStackRenderer {
    public static final CustomModelRenderer INSTANCE = new CustomModelRenderer();
    private final TileEntityItemStackRenderer parent;
    private List<Function<ItemStack, IRenderableModel>> overrides = new ArrayList<Function<ItemStack, IRenderableModel>>();

    private CustomModelRenderer() {
        this.parent = TileEntityItemStackRenderer.field_147719_a;
        TileEntityItemStackRenderer.field_147719_a = this;
        this.registerRenderable(this::defaultModel);
    }

    public void func_192838_a(ItemStack stack, float partialTicks) {
        if (!this.renderInternal(stack, partialTicks)) {
            this.parent.func_192838_a(stack, partialTicks);
        }
    }

    private boolean renderInternal(ItemStack stack, float partialTicks) {
        ListIterator<Function<ItemStack, IRenderableModel>> iter = this.overrides.listIterator(this.overrides.size());
        while (iter.hasPrevious()) {
            Function<ItemStack, IRenderableModel> supplier = iter.previous();
            IRenderableModel model = supplier.apply(stack);
            if (model == null) continue;
            GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
            model.render(stack, partialTicks);
            return true;
        }
        return false;
    }

    public void registerRenderable(Function<ItemStack, IRenderableModel> supplier) {
        this.overrides.add(supplier);
    }

    private IRenderableModel defaultModel(ItemStack stack) {
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, null, null);
        if (model instanceof IRenderableModel) {
            return (IRenderableModel)model;
        }
        return null;
    }
}

