/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.compat.computer;

import it.zerono.mods.zerocore.internal.ZeroCore;
import it.zerono.mods.zerocore.lib.compat.LuaHelper;
import it.zerono.mods.zerocore.lib.compat.computer.ComputerPeripheral;
import it.zerono.mods.zerocore.lib.compat.computer.IComputerMethodHandler;
import it.zerono.mods.zerocore.util.CodeHelper;
import javax.annotation.Nonnull;

public class ComputerMethod<Peripheral extends ComputerPeripheral> {
    public static final Object[] EMPTY_RESULT = new Object[0];
    private final String _name;
    private final IComputerMethodHandler<Peripheral> _handler;
    private final int _minArgumentsCount;
    private final boolean _runOnServerThread;

    public ComputerMethod(@Nonnull String name, @Nonnull IComputerMethodHandler<Peripheral> handler) {
        this(name, handler, 0, false);
    }

    public ComputerMethod(@Nonnull String name, @Nonnull IComputerMethodHandler<Peripheral> handler, int minArgumentsCount) {
        this(name, handler, minArgumentsCount, false);
    }

    public ComputerMethod(@Nonnull String name, @Nonnull IComputerMethodHandler<Peripheral> handler, int minArgumentsCount, boolean runOnServerThread) {
        this._name = name;
        this._handler = handler;
        this._minArgumentsCount = minArgumentsCount;
        this._runOnServerThread = runOnServerThread;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @Nonnull
    public Object[] invoke(@Nonnull Peripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        LuaHelper.validateArgsCount(arguments, this._minArgumentsCount);
        if (this._runOnServerThread) {
            IComputerMethodHandler handler = this._handler;
            CodeHelper.getServerThreadListener().func_152344_a(() -> {
                try {
                    handler.execute(peripheral, arguments);
                }
                catch (Exception ex) {
                    ZeroCore.getLogger().error("Exception raised while running computer method on server thread", (Throwable)ex);
                }
            });
            return EMPTY_RESULT;
        }
        return this._handler.execute(peripheral, arguments);
    }
}

