/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib;

import it.zerono.mods.zerocore.lib.PropertyBlockFacings;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public final class BlockFacings {
    public static final BlockFacings NONE;
    public static final BlockFacings ALL;
    public static final BlockFacings DOWN;
    public static final BlockFacings UP;
    public static final BlockFacings NORTH;
    public static final BlockFacings SOUTH;
    public static final BlockFacings WEST;
    public static final BlockFacings EAST;
    public static final BlockFacings VERTICAL;
    public static final BlockFacings HORIZONTAL;
    public static final BlockFacings AXIS_X;
    public static final BlockFacings AXIS_Y;
    public static final BlockFacings AXIS_Z;
    public static final PropertyBool FACING_DOWN;
    public static final PropertyBool FACING_UP;
    public static final PropertyBool FACING_WEST;
    public static final PropertyBool FACING_EAST;
    public static final PropertyBool FACING_NORTH;
    public static final PropertyBool FACING_SOUTH;
    private byte _value;
    private static Map<Byte, BlockFacings> s_cache;

    public boolean isSet(@Nonnull EnumFacing facing) {
        return 0 != (this._value & 1 << facing.func_176745_a());
    }

    public boolean none() {
        return 0 == this._value;
    }

    public boolean all() {
        return 63 == this._value;
    }

    public boolean down() {
        return this.isSet(EnumFacing.DOWN);
    }

    public boolean up() {
        return this.isSet(EnumFacing.UP);
    }

    public boolean north() {
        return this.isSet(EnumFacing.NORTH);
    }

    public boolean south() {
        return this.isSet(EnumFacing.SOUTH);
    }

    public boolean west() {
        return this.isSet(EnumFacing.WEST);
    }

    public boolean east() {
        return this.isSet(EnumFacing.EAST);
    }

    @Nonnull
    public IBlockState toBlockState(@Nonnull IBlockState state) {
        return state.func_177226_a((IProperty)FACING_DOWN, (Comparable)Boolean.valueOf(this.isSet(EnumFacing.DOWN))).func_177226_a((IProperty)FACING_UP, (Comparable)Boolean.valueOf(this.isSet(EnumFacing.UP))).func_177226_a((IProperty)FACING_WEST, (Comparable)Boolean.valueOf(this.isSet(EnumFacing.WEST))).func_177226_a((IProperty)FACING_EAST, (Comparable)Boolean.valueOf(this.isSet(EnumFacing.EAST))).func_177226_a((IProperty)FACING_NORTH, (Comparable)Boolean.valueOf(this.isSet(EnumFacing.NORTH))).func_177226_a((IProperty)FACING_SOUTH, (Comparable)Boolean.valueOf(this.isSet(EnumFacing.SOUTH)));
    }

    @Nonnull
    public BlockFacings set(@Nonnull EnumFacing facing, boolean value) {
        byte newHash = this._value;
        newHash = value ? (byte)(newHash | 1 << facing.func_176745_a()) : (byte)(newHash & ~(1 << facing.func_176745_a()));
        return BlockFacings.from(newHash);
    }

    public int countFacesIf(boolean areSet) {
        int checkFor = areSet ? 1 : 0;
        int mask = this._value;
        int faces = 0;
        int i = 0;
        while (i < 6) {
            if ((mask & 1) == checkFor) {
                ++faces;
            }
            ++i;
            mask >>>= 1;
        }
        return faces;
    }

    @Nonnull
    public PropertyBlockFacings toProperty() {
        PropertyBlockFacings[] values = PropertyBlockFacings.values();
        for (int i = 0; i < values.length; ++i) {
            if (values[i]._hash != this._value) continue;
            return values[i];
        }
        return PropertyBlockFacings.None;
    }

    @Nonnull
    public BlockPos offsetBlockPos(@Nonnull BlockPos originalPosition) {
        int x = 0;
        int y = 0;
        int z = 0;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!this.isSet(facing)) continue;
            x += facing.func_82601_c();
            y += facing.func_96559_d();
            z += facing.func_82599_e();
        }
        return originalPosition.func_177982_a(x, y, z);
    }

    @Nullable
    public EnumFacing firstIf(boolean isSet) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (isSet != this.isSet(facing)) continue;
            return facing;
        }
        return null;
    }

    @Nonnull
    public static BlockFacings from(boolean down, boolean up, boolean north, boolean south, boolean west, boolean east) {
        return BlockFacings.from(BlockFacings.computeHash(down, up, north, south, west, east));
    }

    @Nonnull
    public static BlockFacings from(@Nonnull boolean[] facings) {
        return BlockFacings.from(BlockFacings.computeHash(facings));
    }

    @Nonnull
    public static BlockFacings from(@Nonnull EnumFacing.Axis axis) {
        switch (axis) {
            default: {
                return AXIS_X;
            }
            case Y: {
                return AXIS_Y;
            }
            case Z: 
        }
        return AXIS_Z;
    }

    @Nonnull
    public static BlockFacings from(@Nonnull EnumFacing.Plane plane) {
        switch (plane) {
            default: {
                return VERTICAL;
            }
            case HORIZONTAL: 
        }
        return HORIZONTAL;
    }

    public String toString() {
        return String.format("Facings: %s%s%s%s%s%s", this.isSet(EnumFacing.DOWN) ? "DOWN " : "", this.isSet(EnumFacing.UP) ? "UP " : "", this.isSet(EnumFacing.NORTH) ? "NORTH " : "", this.isSet(EnumFacing.SOUTH) ? "SOUTH " : "", this.isSet(EnumFacing.WEST) ? "WEST " : "", this.isSet(EnumFacing.EAST) ? "EAST " : "");
    }

    @Nonnull
    static BlockFacings from(@Nonnull Byte hash) {
        BlockFacings facings = s_cache.get(hash);
        if (null == facings) {
            facings = new BlockFacings(hash);
            s_cache.put(hash, facings);
        }
        return facings;
    }

    private BlockFacings(byte value) {
        this._value = value;
    }

    @Nonnull
    static Byte computeHash(boolean down, boolean up, boolean north, boolean south, boolean west, boolean east) {
        byte hash = 0;
        if (down) {
            hash = (byte)(hash | 1 << EnumFacing.DOWN.func_176745_a());
        }
        if (up) {
            hash = (byte)(hash | 1 << EnumFacing.UP.func_176745_a());
        }
        if (north) {
            hash = (byte)(hash | 1 << EnumFacing.NORTH.func_176745_a());
        }
        if (south) {
            hash = (byte)(hash | 1 << EnumFacing.SOUTH.func_176745_a());
        }
        if (west) {
            hash = (byte)(hash | 1 << EnumFacing.WEST.func_176745_a());
        }
        if (east) {
            hash = (byte)(hash | 1 << EnumFacing.EAST.func_176745_a());
        }
        return hash;
    }

    @Nonnull
    static Byte computeHash(@Nonnull boolean[] facings) {
        int len;
        byte hash = 0;
        int n = len = null == facings ? -1 : facings.length;
        if (len < 0 || len > EnumFacing.field_82609_l.length) {
            throw new IllegalArgumentException("Invalid length of facings array");
        }
        for (int i = 0; i < len; ++i) {
            if (!facings[i]) continue;
            hash = (byte)(hash | 1 << EnumFacing.field_82609_l[i].func_176745_a());
        }
        return hash;
    }

    static {
        FACING_DOWN = PropertyBool.func_177716_a((String)"downFacing");
        FACING_UP = PropertyBool.func_177716_a((String)"upFacing");
        FACING_WEST = PropertyBool.func_177716_a((String)"westFacing");
        FACING_EAST = PropertyBool.func_177716_a((String)"eastFacing");
        FACING_NORTH = PropertyBool.func_177716_a((String)"northFacing");
        FACING_SOUTH = PropertyBool.func_177716_a((String)"southFacing");
        s_cache = new HashMap<Byte, BlockFacings>(12);
        Byte hash = BlockFacings.computeHash(false, false, false, false, false, false);
        NONE = new BlockFacings(hash);
        s_cache.put(hash, NONE);
        hash = BlockFacings.computeHash(true, true, true, true, true, true);
        ALL = new BlockFacings(hash);
        s_cache.put(hash, ALL);
        hash = BlockFacings.computeHash(true, false, false, false, false, false);
        DOWN = new BlockFacings(hash);
        s_cache.put(hash, DOWN);
        hash = BlockFacings.computeHash(false, true, false, false, false, false);
        UP = new BlockFacings(hash);
        s_cache.put(hash, UP);
        hash = BlockFacings.computeHash(false, false, true, false, false, false);
        NORTH = new BlockFacings(hash);
        s_cache.put(hash, NORTH);
        hash = BlockFacings.computeHash(false, false, false, true, false, false);
        SOUTH = new BlockFacings(hash);
        s_cache.put(hash, SOUTH);
        hash = BlockFacings.computeHash(false, false, false, false, true, false);
        WEST = new BlockFacings(hash);
        s_cache.put(hash, WEST);
        hash = BlockFacings.computeHash(false, false, false, false, false, true);
        EAST = new BlockFacings(hash);
        s_cache.put(hash, EAST);
        hash = BlockFacings.computeHash(true, true, false, false, false, false);
        VERTICAL = new BlockFacings(hash);
        s_cache.put(hash, VERTICAL);
        hash = BlockFacings.computeHash(false, false, true, true, true, true);
        HORIZONTAL = new BlockFacings(hash);
        s_cache.put(hash, HORIZONTAL);
        hash = BlockFacings.computeHash(false, false, false, false, true, true);
        AXIS_X = new BlockFacings(hash);
        s_cache.put(hash, AXIS_X);
        hash = BlockFacings.computeHash(false, false, true, true, false, false);
        AXIS_Z = new BlockFacings(hash);
        s_cache.put(hash, AXIS_Z);
        AXIS_Y = VERTICAL;
    }
}

