/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.util;

import com.feed_the_beast.ftblib.lib.io.ByteCounterOutputStream;
import com.feed_the_beast.ftblib.lib.util.FileUtils;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.storage.ThreadedFileIOBase;

public class NBTUtils {
    public static final NBTTagByte BYTE_0 = new NBTTagByte(0);
    public static final NBTTagByte BYTE_1 = new NBTTagByte(1);
    private static final TextFormatting[] COLORS = new TextFormatting[]{TextFormatting.BLUE, TextFormatting.DARK_GREEN, TextFormatting.YELLOW, TextFormatting.RED};

    public static void renameTag(NBTTagCompound nbt, String oldName, String newName) {
        NBTBase tag = nbt.func_74781_a(oldName);
        if (tag != null) {
            nbt.func_82580_o(oldName);
            nbt.func_74782_a(newName, tag);
        }
    }

    public static void writeNBT(File file, NBTTagCompound tag) {
        try (FileOutputStream stream = new FileOutputStream(FileUtils.newFile(file));){
            CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)stream);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void writeNBTSafe(File file, NBTTagCompound tag) {
        ThreadedFileIOBase.func_178779_a().func_75735_a(() -> {
            NBTUtils.writeNBT(file, tag);
            return false;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static NBTTagCompound readNBT(File file) {
        if (!file.exists()) return null;
        if (!file.isFile()) {
            return null;
        }
        try (FileInputStream stream = new FileInputStream(file);){
            NBTTagCompound nBTTagCompound = CompressedStreamTools.func_74796_a((InputStream)stream);
            return nBTTagCompound;
        }
        catch (Exception ex) {
            try {
                return CompressedStreamTools.func_74797_a((File)file);
            }
            catch (Exception ex1) {
                return null;
            }
        }
    }

    public static void copyTags(@Nullable NBTTagCompound from, @Nullable NBTTagCompound to) {
        if (from != null && to != null && !from.func_82582_d()) {
            for (String key : from.func_150296_c()) {
                to.func_74782_a(key, from.func_74781_a(key));
            }
        }
    }

    @Nullable
    public static NBTTagCompound minimize(@Nullable NBTTagCompound nbt) {
        if (nbt == null || nbt.func_82582_d()) {
            return null;
        }
        NBTTagCompound nbt1 = null;
        for (String key : nbt.func_150296_c()) {
            NBTBase nbt2 = nbt.func_74781_a(key);
            if (nbt2 instanceof NBTTagCompound) {
                nbt2 = NBTUtils.minimize((NBTTagCompound)nbt2);
            } else if (nbt2 instanceof NBTTagList) {
                nbt2 = NBTUtils.minimize((NBTTagList)nbt2);
            }
            if (nbt2 == null) continue;
            if (nbt1 == null) {
                nbt1 = new NBTTagCompound();
            }
            nbt1.func_74782_a(key, nbt2);
        }
        return nbt1;
    }

    @Nullable
    public static NBTTagList minimize(@Nullable NBTTagList nbt) {
        return nbt == null || nbt.func_82582_d() ? null : nbt;
    }

    public static String getColoredNBTString(@Nullable NBTBase nbt) {
        return NBTUtils.getColoredNBTString(new StringBuilder(), nbt, 0).toString();
    }

    private static StringBuilder getColoredNBTString(StringBuilder builder, @Nullable NBTBase nbt, int level) {
        if (nbt == null) {
            return builder.append(TextFormatting.DARK_GRAY).append("null");
        }
        switch (nbt.func_74732_a()) {
            case 0: {
                return builder.append(TextFormatting.DARK_GRAY).append("null");
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 99: {
                return builder.append(TextFormatting.GRAY).append(nbt.toString());
            }
            case 8: {
                return builder.append(TextFormatting.GRAY).append(nbt.toString());
            }
            case 9: {
                NBTTagList list = (NBTTagList)nbt;
                builder.append(COLORS[level % COLORS.length]).append('[');
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    if (i > 0) {
                        builder.append(TextFormatting.DARK_GRAY).append(',').append(' ');
                    }
                    NBTUtils.getColoredNBTString(builder, list.func_179238_g(i), level + 1);
                }
                return builder.append(COLORS[level % COLORS.length]).append(']');
            }
            case 10: {
                NBTTagCompound map = (NBTTagCompound)nbt;
                builder.append(COLORS[level % COLORS.length]).append('{');
                boolean first = true;
                for (String key : map.func_150296_c()) {
                    if (first) {
                        first = false;
                    } else {
                        builder.append(TextFormatting.DARK_GRAY).append(',').append(' ');
                    }
                    builder.append(TextFormatting.DARK_GRAY).append(key).append(':').append(' ');
                    NBTUtils.getColoredNBTString(builder, map.func_74781_a(key), level + 1);
                }
                return builder.append(COLORS[level % COLORS.length]).append('}');
            }
            case 7: {
                NBTTagByteArray list = (NBTTagByteArray)nbt;
                builder.append(COLORS[level % COLORS.length]).append('[');
                for (int i = 0; i < list.func_150292_c().length; ++i) {
                    if (i > 0) {
                        builder.append(TextFormatting.DARK_GRAY).append(',').append(' ');
                    }
                    builder.append(TextFormatting.GRAY).append(list.func_150292_c()[i]);
                }
                return builder.append(COLORS[level % COLORS.length]).append(']');
            }
            case 11: {
                NBTTagIntArray list = (NBTTagIntArray)nbt;
                builder.append(COLORS[level % COLORS.length]).append('[');
                for (int i = 0; i < list.func_150302_c().length; ++i) {
                    if (i > 0) {
                        builder.append(TextFormatting.DARK_GRAY).append(',').append(' ');
                    }
                    builder.append(TextFormatting.GRAY).append(list.func_150302_c()[i]);
                }
                return builder.append(COLORS[level % COLORS.length]).append(']');
            }
        }
        return builder.append(TextFormatting.GRAY).append(nbt.toString());
    }

    public static long getSizeInBytes(NBTTagCompound nbt, boolean compressed) {
        try {
            ByteCounterOutputStream byteCounter = new ByteCounterOutputStream();
            if (compressed) {
                CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)byteCounter);
            } else {
                CompressedStreamTools.func_74800_a((NBTTagCompound)nbt, (DataOutput)new DataOutputStream(byteCounter));
            }
            return byteCounter.getSize();
        }
        catch (Exception ex) {
            return -1L;
        }
    }

    public static NBTTagCompound getPersistedData(EntityPlayer player, boolean createIfMissing) {
        NBTTagCompound tag = player.getEntityData().func_74775_l("PlayerPersisted");
        if (createIfMissing) {
            player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)tag);
        }
        return tag;
    }
}

