/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.io;

import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.math.BlockDimPos;
import com.feed_the_beast.ftblib.lib.util.BlockUtils;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;

public class DataOut {
    public static final Serializer<String> STRING = DataOut::writeString;
    public static final Serializer<Integer> INT = DataOut::writeInt;
    public static final Serializer<Boolean> BOOLEAN = DataOut::writeBoolean;
    public static final Serializer<UUID> UUID = DataOut::writeUUID;
    public static final Serializer<BlockPos> BLOCK_POS = DataOut::writePos;
    public static final Serializer<BlockDimPos> BLOCK_DIM_POS = DataOut::writeDimPos;
    public static final Serializer<JsonElement> JSON = DataOut::writeJson;
    public static final Serializer<ITextComponent> TEXT_COMPONENT = DataOut::writeTextComponent;
    public static final Serializer<ResourceLocation> RESOURCE_LOCATION = DataOut::writeResourceLocation;
    public static final Serializer<ItemStack> ITEM_STACK = DataOut::writeItemStack;
    public static final Serializer<ChunkPos> CHUNK_POS = (data, pos) -> {
        data.writeVarInt(pos.field_77276_a);
        data.writeVarInt(pos.field_77275_b);
    };
    private final ByteBuf byteBuf;

    public DataOut(ByteBuf io) {
        this.byteBuf = io;
    }

    public int getPosition() {
        return this.byteBuf.writerIndex();
    }

    public void writeBoolean(boolean value) {
        this.byteBuf.writeBoolean(value);
    }

    public void writeByte(int value) {
        this.byteBuf.writeByte(value);
    }

    public void writeBytes(byte[] bytes, int off, int len) {
        this.byteBuf.writeBytes(bytes, off, len);
    }

    public void writeBytes(byte[] bytes) {
        this.writeBytes(bytes, 0, bytes.length);
    }

    public void writeShort(int value) {
        this.byteBuf.writeShort(value);
    }

    public void writeInt(int value) {
        this.byteBuf.writeInt(value);
    }

    public void writeLong(long value) {
        this.byteBuf.writeLong(value);
    }

    public void writeFloat(float value) {
        this.byteBuf.writeFloat(value);
    }

    public void writeDouble(double value) {
        this.byteBuf.writeDouble(value);
    }

    public void writePos(Vec3i pos) {
        this.writeVarInt(pos.func_177958_n());
        this.writeVarInt(pos.func_177956_o());
        this.writeVarInt(pos.func_177952_p());
    }

    public void writeDimPos(BlockDimPos pos) {
        this.writeVarInt(pos.dim);
        this.writeVarInt(pos.posX);
        this.writeVarInt(pos.posY);
        this.writeVarInt(pos.posZ);
    }

    public void writeUUID(UUID id) {
        this.writeLong(id.getMostSignificantBits());
        this.writeLong(id.getLeastSignificantBits());
    }

    public void writeString(String string) {
        if (string.isEmpty()) {
            this.writeVarInt(0);
            return;
        }
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        this.writeVarInt(bytes.length);
        this.writeBytes(bytes);
    }

    public <T> void writeCollection(Collection<T> collection, Serializer<T> serializer) {
        int size = collection.size();
        if (size == 0) {
            this.writeVarInt(0);
            return;
        }
        if (collection instanceof Set) {
            this.writeVarInt(-size);
        } else {
            this.writeVarInt(size);
        }
        for (T object : collection) {
            serializer.write(this, object);
        }
    }

    public <K, V> void writeMap(Map<K, V> map, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        int size = map.size();
        if (size == 0) {
            this.writeVarInt(0);
            return;
        }
        if (map instanceof LinkedHashMap || map instanceof SortedMap) {
            this.writeVarInt(-size);
        } else {
            this.writeVarInt(size);
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            keySerializer.write(this, entry.getKey());
            valueSerializer.write(this, entry.getValue());
        }
    }

    public void writeItemStack(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_77973_b().getRegistryName() == null) {
            this.writeVarInt(0);
            return;
        }
        this.writeVarInt(Item.func_150891_b((Item)stack.func_77973_b()));
        this.writeVarInt(stack.func_190916_E());
        this.writeVarInt(stack.func_77960_j());
        this.writeNBT((NBTTagCompound)(stack.func_77973_b().func_77645_m() || stack.func_77973_b().func_77651_p() ? stack.func_77973_b().getNBTShareTag(stack) : null));
    }

    public void writeNBT(@Nullable NBTTagCompound nbt) {
        if (nbt == null) {
            this.writeByte(0);
        } else {
            try {
                CompressedStreamTools.func_74800_a((NBTTagCompound)nbt, (DataOutput)new ByteBufOutputStream(this.byteBuf));
            }
            catch (IOException ex) {
                throw new EncoderException((Throwable)ex);
            }
        }
    }

    public void writeNBTBase(@Nullable NBTBase nbt) {
        if (nbt == null || nbt.func_74732_a() == 0) {
            this.writeByte(0);
            return;
        }
        this.writeByte(nbt.func_74732_a());
        switch (nbt.func_74732_a()) {
            case 1: {
                this.writeByte(((NBTPrimitive)nbt).func_150290_f());
                return;
            }
            case 2: {
                this.writeShort(((NBTPrimitive)nbt).func_150289_e());
                return;
            }
            case 3: {
                this.writeInt(((NBTPrimitive)nbt).func_150287_d());
                return;
            }
            case 4: {
                this.writeLong(((NBTPrimitive)nbt).func_150291_c());
                return;
            }
            case 5: {
                this.writeFloat(((NBTPrimitive)nbt).func_150288_h());
                return;
            }
            case 6: {
                this.writeDouble(((NBTPrimitive)nbt).func_150286_g());
                return;
            }
            case 8: {
                this.writeString(((NBTTagString)nbt).func_150285_a_());
                return;
            }
            case 10: {
                this.writeNBT((NBTTagCompound)nbt);
                return;
            }
        }
        NBTTagCompound nbt1 = new NBTTagCompound();
        nbt1.func_74782_a("_", nbt);
        this.writeNBT(nbt1);
    }

    public void writeResourceLocation(ResourceLocation r) {
        this.writeString(r.toString());
    }

    public int writeJson(@Nullable JsonElement element) {
        if (JsonUtils.isNull(element)) {
            this.writeByte(0);
            return 0;
        }
        if (element.isJsonObject()) {
            this.writeByte(1);
            Set set = element.getAsJsonObject().entrySet();
            LinkedHashMap map = new LinkedHashMap(set.size());
            for (Map.Entry entry : set) {
                map.put(entry.getKey(), entry.getValue());
            }
            this.writeMap(map, STRING, JSON);
            return 1;
        }
        if (element.isJsonArray()) {
            this.writeByte(2);
            JsonArray json = element.getAsJsonArray();
            ArrayList<JsonElement> collection = new ArrayList<JsonElement>(json.size());
            for (JsonElement json1 : json) {
                collection.add(json1);
            }
            this.writeCollection(collection, JSON);
            return 2;
        }
        JsonPrimitive primitive = element.getAsJsonPrimitive();
        if (primitive.isBoolean()) {
            if (primitive.getAsBoolean()) {
                this.writeByte(5);
                return 5;
            }
            this.writeByte(6);
            return 6;
        }
        if (primitive.isNumber()) {
            if (primitive == JsonUtils.JSON_ZERO) {
                this.writeByte(4);
                return 4;
            }
            Number number = primitive.getAsNumber();
            if (number.doubleValue() == 0.0) {
                this.writeByte(4);
                return 4;
            }
            Class<?> n = number.getClass();
            if (n == Float.class) {
                this.writeByte(8);
                this.writeFloat(primitive.getAsFloat());
                return 8;
            }
            if (n == Double.class) {
                this.writeByte(9);
                this.writeDouble(primitive.getAsDouble());
                return 9;
            }
            this.writeByte(7);
            this.writeVarLong(primitive.getAsLong());
            return 7;
        }
        String string = primitive.getAsString();
        if (string.isEmpty()) {
            this.writeByte(10);
            return 10;
        }
        this.writeByte(3);
        this.writeString(string);
        return 3;
    }

    public void writeTextComponent(@Nullable ITextComponent component) {
        this.writeJson(JsonUtils.serializeTextComponent(component));
    }

    public void writeBlockState(IBlockState state) {
        this.writeInt(state == BlockUtils.AIR_STATE ? 0 : Block.func_176210_f((IBlockState)state));
    }

    public void writeIcon(@Nullable Icon icon) {
        this.writeJson((icon == null ? Icon.EMPTY : icon).getJson());
    }

    public void writeIntList(IntCollection collection) {
        this.writeVarInt(collection.size());
        if (!collection.isEmpty()) {
            IntIterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.writeInt(iterator.nextInt());
            }
        }
    }

    public <E> void write(E object, Serializer<E> serializer) {
        serializer.write(this, object);
    }

    public void writeVarInt(int value) {
        if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
            this.writeByte(123);
            this.writeInt(value);
        } else if (value > 127 || value < -128) {
            this.writeByte(122);
            this.writeShort(value);
        } else if (value >= 121 && value <= 123) {
            this.writeByte(121);
            this.writeByte(value);
        } else {
            this.writeByte(value);
        }
    }

    public void writeVarLong(long value) {
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            this.writeByte(124);
            this.writeLong(value);
        } else if (value > 32767L || value < -32768L) {
            this.writeByte(123);
            this.writeInt((int)value);
        } else if (value > 127L || value < -128L) {
            this.writeByte(122);
            this.writeShort((int)value);
        } else if (value >= 121L && value <= 124L) {
            this.writeByte(121);
            this.writeByte((int)value);
        } else {
            this.writeByte((int)value);
        }
    }

    @FunctionalInterface
    public static interface Serializer<T> {
        public void write(DataOut var1, T var2);
    }
}

