/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.icon;

import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import net.minecraft.util.math.MathHelper;

public class MutableColor4I
extends Color4I {
    public static final Color4I TEMP = new MutableColor4I(255, 255, 255, 255);

    MutableColor4I(int r, int g, int b, int a) {
        super(r, g, b, a);
    }

    @Override
    public MutableColor4I copy() {
        return new MutableColor4I(this.red, this.green, this.blue, this.alpha);
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public MutableColor4I mutable() {
        return this;
    }

    @Override
    public JsonElement getJson() {
        if (this.isEmpty()) {
            return JsonNull.INSTANCE;
        }
        JsonObject json = new JsonObject();
        json.addProperty("red", (Number)this.red);
        json.addProperty("green", (Number)this.green);
        json.addProperty("blue", (Number)this.blue);
        if (this.alpha < 255) {
            json.addProperty("alpha", (Number)this.alpha);
        }
        json.addProperty("mutable", Boolean.valueOf(true));
        return json;
    }

    public Color4I set(int r, int g, int b, int a) {
        this.red = r & 0xFF;
        this.green = g & 0xFF;
        this.blue = b & 0xFF;
        this.alpha = a & 0xFF;
        return this;
    }

    public Color4I set(Color4I col, int a) {
        return this.set(col.red, col.green, col.blue, a);
    }

    public Color4I set(Color4I col) {
        return this.set(col, col.alpha);
    }

    public Color4I set(int col, int a) {
        return this.set(col >> 16, col >> 8, col, a);
    }

    public Color4I set(int col) {
        return this.set(col, col >> 24);
    }

    public Color4I setAlpha(int a) {
        this.alpha = a;
        return this;
    }

    public Color4I addBrightness(int b) {
        return this.set(MathHelper.func_76125_a((int)(this.red + b), (int)0, (int)255), MathHelper.func_76125_a((int)(this.green + b), (int)0, (int)255), MathHelper.func_76125_a((int)(this.blue + b), (int)0, (int)255), this.alpha);
    }

    private static int toint(float f) {
        return (int)(f * 255.0f + 0.5f);
    }

    public Color4I setFromHSB(float h, float s, float b) {
        this.blue = 0;
        this.green = 0;
        this.red = 0;
        if (s <= 0.0f || b <= 0.0f) {
            this.green = this.blue = MutableColor4I.toint(b);
            this.red = this.blue;
            return this;
        }
        if (s > 1.0f) {
            s = 1.0f;
        }
        if (b > 1.0f) {
            b = 1.0f;
        }
        float h6 = (h - (float)MathHelper.func_76141_d((float)h)) * 6.0f;
        float f = h6 - (float)MathHelper.func_76141_d((float)h6);
        float p = b * (1.0f - s);
        float q = b * (1.0f - s * f);
        float t = b * (1.0f - s * (1.0f - f));
        switch ((int)h6) {
            case 0: {
                this.red = MutableColor4I.toint(b);
                this.green = MutableColor4I.toint(t);
                this.blue = MutableColor4I.toint(p);
                return this;
            }
            case 1: {
                this.red = MutableColor4I.toint(q);
                this.green = MutableColor4I.toint(b);
                this.blue = MutableColor4I.toint(p);
                return this;
            }
            case 2: {
                this.red = MutableColor4I.toint(p);
                this.green = MutableColor4I.toint(b);
                this.blue = MutableColor4I.toint(t);
                return this;
            }
            case 3: {
                this.red = MutableColor4I.toint(p);
                this.green = MutableColor4I.toint(q);
                this.blue = MutableColor4I.toint(b);
                return this;
            }
            case 4: {
                this.red = MutableColor4I.toint(t);
                this.green = MutableColor4I.toint(p);
                this.blue = MutableColor4I.toint(b);
                return this;
            }
        }
        this.red = MutableColor4I.toint(b);
        this.green = MutableColor4I.toint(p);
        this.blue = MutableColor4I.toint(q);
        return this;
    }

    static class None
    extends MutableColor4I {
        private boolean hasColor = false;

        None() {
            super(255, 255, 255, 255);
        }

        @Override
        public Color4I set(int r, int g, int b, int a) {
            this.hasColor = true;
            return super.set(r, g, b, a);
        }

        @Override
        public boolean isEmpty() {
            return !this.hasColor;
        }

        @Override
        public BufferedImage readImage() {
            BufferedImage image = new BufferedImage(1, 1, 2);
            image.setRGB(0, 0, 0);
            return image;
        }
    }
}

