/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui;

import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;

public class TextBox
extends Widget {
    private boolean isFocused = false;
    public int charLimit = 250;
    public Color4I textColor = Icon.EMPTY;
    public String ghostText = "";
    private String text = "";
    private int lineScrollOffset;
    private int cursorPosition;
    private int selectionEnd;
    private boolean validText;

    public TextBox(Panel panel) {
        super(panel);
        this.setText("", false);
    }

    public final boolean isFocused() {
        return this.isFocused;
    }

    public final void setFocused(boolean v) {
        this.isFocused = v;
        this.validText = this.isValid(this.text);
        Keyboard.enableRepeatEvents((boolean)this.isFocused);
    }

    @Override
    public void onClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public final String getText() {
        return this.text;
    }

    public String getSelectedText() {
        return this.text.substring(this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd, this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition);
    }

    public final void setText(String s, boolean triggerChange) {
        this.text = s;
        if (this.text.isEmpty()) {
            this.lineScrollOffset = 0;
            this.cursorPosition = 0;
            this.selectionEnd = 0;
        }
        this.validText = this.isValid(s);
        if (this.validText && triggerChange) {
            this.onTextChanged();
        }
    }

    public final void setText(String s) {
        this.setText(s, true);
    }

    public void setCursorPosition(int pos) {
        this.cursorPosition = pos;
        int i = this.text.length();
        this.cursorPosition = MathHelper.func_76125_a((int)this.cursorPosition, (int)0, (int)i);
        this.setSelectionPos(this.cursorPosition);
    }

    public void moveCursorBy(int num) {
        this.setCursorPosition(this.selectionEnd + num);
    }

    public void writeText(String textToWrite) {
        int l;
        if (!textToWrite.isEmpty() && !this.allowInput()) {
            return;
        }
        String s = "";
        String s1 = ChatAllowedCharacters.func_71565_a((String)textToWrite);
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        int k = this.charLimit - this.text.length() - (i - j);
        if (!this.text.isEmpty()) {
            s = s + this.text.substring(0, i);
        }
        if (k < s1.length()) {
            s = s + s1.substring(0, k);
            l = k;
        } else {
            s = s + s1;
            l = s1.length();
        }
        if (!this.text.isEmpty() && j < this.text.length()) {
            s = s + this.text.substring(j);
        }
        this.setText(s);
        this.moveCursorBy(i - this.selectionEnd + l);
    }

    public void setSelectionPos(int position) {
        int i = this.text.length();
        if (position > i) {
            position = i;
        }
        if (position < 0) {
            position = 0;
        }
        this.selectionEnd = position;
        if (this.lineScrollOffset > i) {
            this.lineScrollOffset = i;
        }
        int j = this.width - 10;
        Theme theme = this.getGui().getTheme();
        String s = theme.trimStringToWidth(this.text.substring(this.lineScrollOffset), j);
        int k = s.length() + this.lineScrollOffset;
        if (position == this.lineScrollOffset) {
            this.lineScrollOffset -= theme.trimStringToWidthReverse(this.text, j).length();
        }
        if (position > k) {
            this.lineScrollOffset += position - k;
        } else if (position <= this.lineScrollOffset) {
            this.lineScrollOffset -= this.lineScrollOffset - position;
        }
        this.lineScrollOffset = MathHelper.func_76125_a((int)this.lineScrollOffset, (int)0, (int)i);
    }

    public int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPos(numWords, this.cursorPosition);
    }

    public int getNthWordFromPos(int n, int pos) {
        return this.getNthWordFromPosWS(n, pos, true);
    }

    public int getNthWordFromPosWS(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public boolean allowInput() {
        return true;
    }

    public void deleteWords(int num) {
        if (!this.text.isEmpty() && this.allowInput()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(num) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int num) {
        if (this.text.isEmpty() || !this.allowInput()) {
            return;
        }
        if (this.selectionEnd != this.cursorPosition) {
            this.writeText("");
        } else {
            boolean flag = num < 0;
            int i = flag ? this.cursorPosition + num : this.cursorPosition;
            int j = flag ? this.cursorPosition : this.cursorPosition + num;
            String s = "";
            if (i >= 0) {
                s = this.text.substring(0, i);
            }
            if (j < this.text.length()) {
                s = s + this.text.substring(j);
            }
            this.setText(s);
            if (flag) {
                this.moveCursorBy(num);
            }
        }
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            this.setFocused(true);
            Keyboard.enableRepeatEvents((boolean)true);
            if (button.isLeft()) {
                if (this.isFocused) {
                    int i = this.getMouseX() - this.getX();
                    Theme theme = this.getGui().getTheme();
                    String s = theme.trimStringToWidth(this.text.substring(this.lineScrollOffset), this.width);
                    this.setCursorPosition(theme.trimStringToWidth(s, i).length() + this.lineScrollOffset);
                }
            } else if (button.isRight() && this.getText().length() > 0 && this.allowInput()) {
                this.setText("");
            }
            return true;
        }
        Keyboard.enableRepeatEvents((boolean)false);
        this.setFocused(false);
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, char keyChar) {
        if (!this.isFocused()) {
            return false;
        }
        if (TextBox.isKeyComboCtrlA(keyCode)) {
            this.setCursorPosition(this.text.length());
            this.setSelectionPos(0);
            return true;
        }
        if (TextBox.isKeyComboCtrlC(keyCode)) {
            TextBox.setClipboardString(this.getSelectedText());
            return true;
        }
        if (TextBox.isKeyComboCtrlV(keyCode)) {
            this.writeText(TextBox.getClipboardString());
            return true;
        }
        if (TextBox.isKeyComboCtrlX(keyCode)) {
            TextBox.setClipboardString(this.getSelectedText());
            this.writeText("");
            return true;
        }
        switch (keyCode) {
            case 14: {
                if (TextBox.isCtrlKeyDown()) {
                    this.deleteWords(-1);
                } else {
                    this.deleteFromCursor(-1);
                }
                return true;
            }
            case 199: {
                if (TextBox.isShiftKeyDown()) {
                    this.setSelectionPos(0);
                } else {
                    this.setCursorPosition(0);
                }
                return true;
            }
            case 203: {
                if (TextBox.isShiftKeyDown()) {
                    if (TextBox.isCtrlKeyDown()) {
                        this.setSelectionPos(this.getNthWordFromPos(-1, this.selectionEnd));
                    } else {
                        this.setSelectionPos(this.selectionEnd - 1);
                    }
                } else if (TextBox.isCtrlKeyDown()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 205: {
                if (TextBox.isShiftKeyDown()) {
                    if (TextBox.isCtrlKeyDown()) {
                        this.setSelectionPos(this.getNthWordFromPos(1, this.selectionEnd));
                    } else {
                        this.setSelectionPos(this.selectionEnd + 1);
                    }
                } else if (TextBox.isCtrlKeyDown()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 207: {
                if (TextBox.isShiftKeyDown()) {
                    this.setSelectionPos(this.text.length());
                } else {
                    this.setCursorPosition(this.text.length());
                }
                return true;
            }
            case 211: {
                if (TextBox.isCtrlKeyDown()) {
                    this.deleteWords(1);
                } else {
                    this.deleteFromCursor(1);
                }
                return true;
            }
            case 28: {
                if (this.validText) {
                    this.setFocused(false);
                    this.onEnterPressed();
                }
                return true;
            }
            case 15: {
                if (this.validText) {
                    this.setFocused(false);
                    this.onTabPressed();
                }
                return true;
            }
        }
        if (ChatAllowedCharacters.func_71566_a((char)keyChar)) {
            this.writeText(Character.toString(keyChar));
            return true;
        }
        return false;
    }

    public void onTextChanged() {
    }

    public void onTabPressed() {
    }

    public void onEnterPressed() {
    }

    @Override
    public void draw(Theme theme, int x, int y, int w, int h) {
        this.drawTextBox(theme, x, y, w, h);
        boolean drawGhostText = !this.isFocused() && this.text.isEmpty() && !this.ghostText.isEmpty();
        String textToDraw = drawGhostText ? TextFormatting.ITALIC + this.ghostText : this.text;
        GuiHelper.pushScissor(this.getScreen(), x, y, w, h);
        Color4I col = this.validText ? (this.textColor.isEmpty() ? theme.getContentColor(WidgetType.NORMAL) : this.textColor).withAlpha(drawGhostText ? 120 : 255) : Color4I.RED;
        int j = this.cursorPosition - this.lineScrollOffset;
        int k = this.selectionEnd - this.lineScrollOffset;
        String s = theme.trimStringToWidth(textToDraw.substring(this.lineScrollOffset), w);
        int textX = x + 4;
        int textY = y + (h - 8) / 2;
        int textX1 = textX;
        if (k > s.length()) {
            k = s.length();
        }
        if (!s.isEmpty()) {
            String s1 = j > 0 && j <= s.length() ? s.substring(0, j) : s;
            textX1 = theme.drawString(s1, textX, textY, col, 0);
        }
        boolean drawCursor = this.cursorPosition < textToDraw.length() || textToDraw.length() >= this.charLimit;
        int cursorX = textX1;
        if (j <= 0 || j > s.length()) {
            cursorX = j > 0 ? textX + w : textX;
        } else if (drawCursor) {
            cursorX = textX1 - 1;
        }
        if (j > 0 && j < s.length()) {
            theme.drawString(s.substring(j), textX1, textY, col, 0);
        }
        if (j >= 0 && j <= s.length() && this.isFocused() && Minecraft.func_71386_F() % 1000L > 500L) {
            if (drawCursor) {
                col.draw(cursorX, textY - 1, 1, theme.getFontHeight() + 2);
            } else {
                col.draw(cursorX, textY + theme.getFontHeight() - 2, 5, 1);
            }
        }
        if (k != j) {
            int l1 = textX + theme.getStringWidth(s.substring(0, k));
            int startX = cursorX;
            int startY = textY - 1;
            int endX = l1 - 1;
            int endY = textY + 1 + theme.getFontHeight();
            if (startX < endX) {
                int i = startX;
                startX = endX;
                endX = i;
            }
            if (startY < endY) {
                int j12 = startY;
                startY = endY;
                endY = j12;
            }
            if (endX > x + w) {
                endX = x + w;
            }
            if (startX > x + w) {
                startX = x + w;
            }
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179115_u();
            GlStateManager.func_187422_a((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            vertexbuffer.func_181662_b((double)startX, (double)endY, 0.0).func_181675_d();
            vertexbuffer.func_181662_b((double)endX, (double)endY, 0.0).func_181675_d();
            vertexbuffer.func_181662_b((double)endX, (double)startY, 0.0).func_181675_d();
            vertexbuffer.func_181662_b((double)startX, (double)startY, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179134_v();
            GlStateManager.func_179098_w();
        }
        GuiHelper.popScissor(this.getScreen());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawTextBox(Theme theme, int x, int y, int w, int h) {
        theme.drawTextBox(x, y, w, h);
    }

    public boolean isValid(String txt) {
        return true;
    }

    public final boolean isTextValid() {
        return this.validText;
    }
}

