/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.util;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;

public enum Format {
    BLACK(1),
    BLUE(12),
    BOLD('\u0002'),
    BROWN(5),
    CYAN(11),
    DARK_BLUE(2),
    DARK_GRAY(14),
    DARK_GREEN(3),
    GREEN(9),
    ITALIC('\u001d'),
    LIGHT_GRAY(15),
    MAGENTA(13),
    RESET('\u000f'),
    OLIVE(7),
    PURPLE(6),
    RED(4),
    REVERSE('\u0016'),
    TEAL(10),
    UNDERLINE('\u001f'),
    WHITE(0),
    YELLOW(8);

    private final int color;
    private final boolean isColor;
    private final String toString;
    public static final char COLOR_CHAR = '\u0003';
    private static final Pattern COLOR_REGEX;
    private static final Pattern FORMAT_REGEX;

    private Format(char ch) {
        this.color = -1;
        this.isColor = false;
        this.toString = String.valueOf(ch);
    }

    private Format(int color) {
        this.color = color;
        this.isColor = true;
        this.toString = '\u0003' + (color < 10 ? "0" : "") + color;
    }

    @Nonnull
    public static String stripAll(@Nonnull String input) {
        return Format.stripColor(Format.stripFormatting(input));
    }

    @Nonnull
    public static String stripColor(@Nonnull String input) {
        Sanity.nullCheck(input, "Input cannot be null");
        return COLOR_REGEX.matcher(input).replaceAll("");
    }

    @Nonnull
    public static String stripFormatting(@Nonnull String input) {
        Sanity.nullCheck(input, "Input cannot be null");
        return FORMAT_REGEX.matcher(input).replaceAll("");
    }

    public boolean isColor() {
        return this.isColor;
    }

    public int getColorChar() {
        return this.color;
    }

    @Nonnull
    public String toString() {
        return this.toString;
    }

    @Nonnull
    public String withBackground(@Nonnull Format background) {
        Sanity.nullCheck(background, "Background cannot be null");
        Sanity.truthiness(this.isColor, "Cannot use non-color foreground.");
        Sanity.truthiness(background.isColor, "Cannot use non-color background");
        return this.toString() + ',' + background.toString().substring(1);
    }

    static {
        COLOR_REGEX = Pattern.compile("\u0003[0-9]{1,2}(?:,[0-9]{1,2})?");
        FORMAT_REGEX = Pattern.compile("[" + (Object)((Object)BOLD) + (Object)((Object)RESET) + (Object)((Object)REVERSE) + (Object)((Object)UNDERLINE) + ']');
    }
}

