/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.event.abstractbase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Actor;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.MessageTag;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ServerMessage;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.abstractbase.ActorEventBase;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.helper.ClientReceiveServerMessageEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public class ClientReceiveServerMessageEventBase
extends ActorEventBase<Actor>
implements ClientReceiveServerMessageEvent {
    private final List<String> parameters;
    private final String command;
    private final ServerMessage message;

    public ClientReceiveServerMessageEventBase(@Nonnull Client client, @Nonnull ServerMessage serverMessage, @Nonnull Actor server, @Nonnull String command, @Nonnull List<String> parameters) {
        super(client, Collections.singletonList(Sanity.nullCheck(serverMessage, "Server message cannot be null")), server);
        this.parameters = Collections.unmodifiableList(new ArrayList(Sanity.nullCheck(parameters, "Parameters cannot be null")));
        this.message = serverMessage;
        this.command = Sanity.nullCheck(command, "Command cannot be null");
    }

    @Override
    @Nonnull
    public List<String> getParameters() {
        return this.parameters;
    }

    @Override
    @Nonnull
    public String getCommand() {
        return this.command;
    }

    @Override
    @Nonnull
    public List<MessageTag> getMessageTags() {
        return this.message.getTags();
    }

    @Override
    @Nonnull
    public String getOriginalMessage() {
        return this.message.getMessage();
    }

    @Override
    @Nonnull
    public ServerMessage getServerMessage() {
        return this.message;
    }

    @Override
    @Nonnull
    protected ToStringer toStringer() {
        return super.toStringer().add("message", this.message);
    }
}

