/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.element;

import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.ChannelModeCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.KickCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.TopicCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Actor;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.MessageReceiver;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Staleable;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.User;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelUserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ModeInfo;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ModeStatusList;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;

public interface Channel
extends MessageReceiver,
Staleable {
    @Nonnull
    default public Optional<Channel> getLatest() {
        return this.getClient().getChannel(this.getName());
    }

    @Nonnull
    public Optional<List<ModeInfo>> getModeInfoList(@Nonnull ChannelMode var1);

    @Nonnull
    public ModeStatusList<ChannelMode> getModes();

    @Nonnull
    public List<String> getNicknames();

    @Nonnull
    public Topic getTopic();

    @Nonnull
    public Optional<User> getUser(@Nonnull String var1);

    @Nonnull
    public List<User> getUsers();

    @Nonnull
    public Optional<SortedSet<ChannelUserMode>> getUserModes(@Nonnull String var1);

    @Nonnull
    default public Optional<SortedSet<ChannelUserMode>> getUserModes(@Nonnull User user) {
        return this.getUserModes(Sanity.nullCheck(user, "User cannot be null").getNick());
    }

    public boolean hasCompleteUserData();

    default public void join() {
        this.getClient().addChannel(this.getName());
    }

    default public void join(@Nonnull String key) {
        this.getClient().addKeyProtectedChannel(this.getName(), key);
    }

    default public void kick(@Nonnull User user, @Nonnull String reason) {
        this.commands().kick().target(user).reason(reason).execute();
    }

    default public void kick(@Nonnull User user) {
        this.commands().kick().target(user).execute();
    }

    @Nonnull
    public Commands commands();

    default public void part() {
        this.getClient().removeChannel(this.getName());
    }

    default public void part(@Nonnull String reason) {
        this.getClient().removeChannel(this.getName(), reason);
    }

    public void setModeInfoTracking(@Nonnull ChannelMode var1, boolean var2);

    default public void setTopic(@Nonnull String topic) {
        this.commands().topic().topic(topic).execute();
    }

    public static interface Topic {
        @Nonnull
        public Optional<Actor> getSetter();

        @Nonnull
        public Optional<Instant> getTime();

        @Nonnull
        public Optional<String> getValue();
    }

    public static interface Commands {
        @Nonnull
        public ChannelModeCommand mode();

        @Nonnull
        public KickCommand kick();

        @Nonnull
        public TopicCommand topic();
    }
}

