/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.feature;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.DefaultISupportParameter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportCaseMapping;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportChanLimit;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportChanModes;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportChanTypes;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportChannelLen;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportModes;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportNetwork;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportNickLen;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportPrefix;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportTopicLen;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportWhoX;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ISupportParameter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.exception.KittehServerISupportException;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.ISupportManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.AbstractNameValueProcessor;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.TriFunction;

public class DefaultISupportManager
extends AbstractNameValueProcessor<ISupportParameter>
implements ISupportManager {
    public DefaultISupportManager(Client.WithManagement client) {
        super(client);
        this.registerParameter("CASEMAPPING", DefaultISupportCaseMapping::new);
        this.registerParameter("CHANNELLEN", DefaultISupportChannelLen::new);
        this.registerParameter("CHANLIMIT", DefaultISupportChanLimit::new);
        this.registerParameter("CHANMODES", DefaultISupportChanModes::new);
        this.registerParameter("CHANTYPES", DefaultISupportChanTypes::new);
        this.registerParameter("MODES", DefaultISupportModes::new);
        this.registerParameter("NETWORK", DefaultISupportNetwork::new);
        this.registerParameter("NICKLEN", DefaultISupportNickLen::new);
        this.registerParameter("PREFIX", DefaultISupportPrefix::new);
        this.registerParameter("TOPICLEN", DefaultISupportTopicLen::new);
        this.registerParameter("WHOX", DefaultISupportWhoX::new);
    }

    @Override
    @Nonnull
    public Optional<TriFunction<Client, String, String, ? extends ISupportParameter>> getCreator(@Nonnull String tagName) {
        return this.getCreatorByName(tagName);
    }

    @Override
    @Nonnull
    public Optional<TriFunction<Client, String, String, ? extends ISupportParameter>> registerParameter(@Nonnull String tagName, @Nonnull TriFunction<Client, String, String, ? extends ISupportParameter> function) {
        return this.registerCreator(tagName, new AbstractNameValueProcessor.Creator<ISupportParameter>(function));
    }

    @Override
    @Nonnull
    public Optional<TriFunction<Client, String, String, ? extends ISupportParameter>> unregisterParameter(@Nonnull String tagName) {
        return this.unregisterCreator(tagName);
    }

    @Override
    @Nonnull
    public ISupportParameter createParameter(@Nonnull String tag) {
        String value;
        String tagName;
        int index = tag.indexOf(61);
        if (index > -1 && index < tag.length() - 1) {
            tagName = tag.substring(0, index);
            value = tag.substring(index + 1);
        } else {
            tagName = tag;
            value = null;
        }
        ISupportParameter iSupportParameter = null;
        AbstractNameValueProcessor.Creator creator = this.getRegistrations().get(tagName);
        if (creator != null) {
            try {
                iSupportParameter = (ISupportParameter)creator.getFunction().apply(this.getClient(), tagName, value);
            }
            catch (KittehServerISupportException thrown) {
                this.getClient().getExceptionListener().queue(new KittehServerISupportException(tag, "Creator failed: " + thrown.getMessage()));
            }
            catch (Exception thrown) {
                this.getClient().getExceptionListener().queue(new KittehServerISupportException(tag, "Creator failed", thrown));
            }
        }
        if (iSupportParameter == null) {
            iSupportParameter = new DefaultISupportParameter(this.getClient(), tagName, value);
        }
        return iSupportParameter;
    }
}

