/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.WhoisData;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public class DefaultWhoisData
implements WhoisData {
    private final Client client;
    private final String account;
    private final Set<String> channels;
    private final String name;
    private final String nick;
    private final String userString;
    private final String host;
    private final long creationTime;
    private final String realName;
    private final String server;
    private final Long idleTime;
    private final String serverDescription;
    private final boolean secureConnection;
    private final String operatorInformation;
    private final Long signOnTime;
    private final boolean away;
    private final String awayMessage;

    public DefaultWhoisData(@Nonnull Client client, @Nullable String account, @Nonnull Set<String> channels, @Nonnull String nick, @Nonnull String userString, @Nonnull String host, @Nullable String realName, @Nullable String server, @Nullable String serverDescription, boolean secureConnection, @Nullable String operatorInformation, @Nullable Long idleTime, @Nullable Long signOnTime, @Nullable String awayMessage) {
        this.client = client;
        this.account = account;
        this.channels = Collections.unmodifiableSet(new HashSet<String>(channels));
        this.name = nick + '!' + userString + '@' + host;
        this.nick = nick;
        this.userString = userString;
        this.host = host;
        this.realName = realName;
        this.server = server;
        this.serverDescription = serverDescription;
        this.operatorInformation = operatorInformation;
        this.secureConnection = secureConnection;
        this.idleTime = idleTime;
        this.signOnTime = signOnTime;
        this.away = awayMessage != null;
        this.awayMessage = awayMessage;
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    @Nonnull
    public Optional<String> getAccount() {
        return Optional.ofNullable(this.account);
    }

    @Override
    @Nonnull
    public Optional<String> getAwayMessage() {
        return Optional.ofNullable(this.awayMessage);
    }

    @Override
    @Nonnull
    public Set<String> getChannels() {
        return this.channels;
    }

    @Override
    @Nonnull
    public String getHost() {
        return this.host;
    }

    @Override
    @Nonnull
    public String getNick() {
        return this.nick;
    }

    @Override
    @Nonnull
    public Optional<String> getRealName() {
        return Optional.ofNullable(this.realName);
    }

    @Override
    @Nonnull
    public Optional<String> getServer() {
        return Optional.ofNullable(this.server);
    }

    @Override
    @Nonnull
    public String getUserString() {
        return this.userString;
    }

    @Override
    public boolean isAway() {
        return this.away;
    }

    @Override
    @Nonnull
    public String getMessagingName() {
        return this.nick;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public Client getClient() {
        return this.client;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    @Nonnull
    public Optional<Long> getIdleTime() {
        return Optional.ofNullable(this.idleTime);
    }

    @Override
    @Nonnull
    public Optional<String> getOperatorInformation() {
        return Optional.ofNullable(this.operatorInformation);
    }

    @Override
    @Nonnull
    public Optional<String> getServerDescription() {
        return Optional.ofNullable(this.serverDescription);
    }

    @Override
    @Nonnull
    public Optional<Long> getSignOnTime() {
        return Optional.ofNullable(this.signOnTime);
    }

    @Override
    public boolean isSecureConnection() {
        return this.secureConnection;
    }

    @Nonnull
    public String toString() {
        return new ToStringer(this).add("client", this.client).add("account", this.account).add("channels", this.channels).add("name", this.name).add("creationTime", this.creationTime).add("realName", this.realName).add("server", this.server).add("serverDescription", this.serverDescription).add("secureConnection", this.secureConnection).add("operatorInformation", this.operatorInformation).add("idleTime", this.idleTime).add("signOnTime", this.signOnTime).add("awayMessage", this.awayMessage).toString();
    }

    public static class Builder {
        private final Client client;
        private String account;
        private final Set<String> channels = new HashSet<String>();
        private final String nick;
        private String userString;
        private String host;
        private String realName;
        private String server;
        private String serverDescription;
        private boolean secure;
        private String operatorInformation;
        private Long idleTime;
        private Long signOnTime;
        private String awayMessage;

        public Builder(@Nonnull Client client, @Nonnull String nick) {
            this.client = client;
            this.nick = nick;
        }

        @Nonnull
        public String getNick() {
            return this.nick;
        }

        public void setAccount(@Nonnull String account) {
            this.account = account;
        }

        public void addChannels(@Nonnull String channels) {
            Collections.addAll(this.channels, Sanity.nullCheck(channels, "Channels cannot be null").split(" "));
        }

        public void setAway(@Nonnull String awayMessage) {
            this.awayMessage = awayMessage;
        }

        public void setUserString(@Nonnull String userString) {
            this.userString = userString;
        }

        public void setHost(@Nonnull String host) {
            this.host = host;
        }

        public void setRealName(@Nonnull String realName) {
            this.realName = realName;
        }

        public void setServer(@Nonnull String server) {
            this.server = server;
        }

        public void setServerDescription(@Nonnull String serverDescription) {
            this.serverDescription = serverDescription;
        }

        public void setSecure() {
            this.secure = true;
        }

        public void setOperatorInformation(@Nonnull String operatorInformation) {
            this.operatorInformation = operatorInformation;
        }

        public void setIdleTime(long idleTime) {
            this.idleTime = idleTime;
        }

        public void setSignOnTime(long signOnTime) {
            this.signOnTime = signOnTime;
        }

        @Nonnull
        public WhoisData build() {
            return new DefaultWhoisData(this.client, this.account, this.channels, this.nick, this.userString, this.host, this.realName, this.server, this.serverDescription, this.secure, this.operatorInformation, this.idleTime, this.signOnTime, this.awayMessage);
        }
    }
}

