/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.ChannelCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ISupportParameter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.User;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelUserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ModeStatus;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ModeStatusList;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public class ChannelModeCommand
extends ChannelCommand {
    private static final int PARAMETER_MODES_PER_LINE = 3;
    private final List<ModeStatus<ChannelMode>> changes = new ArrayList<ModeStatus<ChannelMode>>();

    public ChannelModeCommand(@Nonnull Client client, @Nonnull String channel) {
        super(client, channel);
    }

    @Nonnull
    public ChannelModeCommand add(boolean add, @Nonnull ChannelMode mode) {
        return this.addChange(add, mode, null);
    }

    @Nonnull
    public ChannelModeCommand add(boolean add, @Nonnull ChannelMode mode, @Nonnull String parameter) {
        return this.addChange(add, mode, Sanity.nullCheck(parameter, "Parameter cannot be null"));
    }

    @Nonnull
    public ChannelModeCommand add(boolean add, @Nonnull ChannelUserMode mode, @Nonnull User parameter) {
        Sanity.nullCheck(parameter, "User cannot be null");
        Sanity.truthiness(parameter.getClient() == this.getClient(), "User comes from a different Client");
        return this.addChange(add, mode, parameter.getNick());
    }

    @Nonnull
    private synchronized ChannelModeCommand addChange(boolean add, @Nonnull ChannelMode mode, @Nullable String parameter) {
        Sanity.nullCheck(mode, "Mode cannot be null");
        Sanity.truthiness(mode.getClient() == this.getClient(), "Mode comes from a different Client");
        if (parameter != null) {
            Sanity.safeMessageCheck(parameter, "Parameter");
            this.changes.add(new ModeStatus<ChannelMode>(add, mode, parameter));
        } else {
            this.changes.add(new ModeStatus<ChannelMode>(add, mode));
        }
        return this;
    }

    @Override
    public synchronized void execute() {
        if (this.changes.isEmpty()) {
            this.getClient().sendRawLine("MODE " + this.getChannel());
            return;
        }
        int parameterModesPerLine = -1;
        Optional<ISupportParameter.Modes> modes = this.getClient().getServerInfo().getISupportParameter("MODES", ISupportParameter.Modes.class);
        if (modes.isPresent()) {
            parameterModesPerLine = modes.get().getInteger();
        }
        if (parameterModesPerLine < 1) {
            parameterModesPerLine = 3;
        }
        ArrayList<ModeStatus<ChannelMode>> queue = new ArrayList<ModeStatus<ChannelMode>>();
        int currentParamModes = 0;
        for (ModeStatus<ChannelMode> modeChange : this.changes) {
            if (modeChange.getParameter().isPresent() && ++currentParamModes > parameterModesPerLine) {
                this.send(queue);
                currentParamModes = 0;
            }
            queue.add(modeChange);
        }
        if (!queue.isEmpty()) {
            this.send(queue);
        }
    }

    private void send(@Nonnull List<ModeStatus<ChannelMode>> queue) {
        this.getClient().sendRawLine("MODE " + this.getChannel() + ' ' + ModeStatusList.of(new ArrayList(queue)).getStatusString());
        queue.clear();
    }

    @Override
    @Nonnull
    protected ToStringer toStringer() {
        return super.toStringer().add("changes", this.changes);
    }
}

