/*
 * Decompiled with CFR 0.152.
 */
package se.rupy.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.HashMap;
import java.util.StringTokenizer;
import se.rupy.http.Deploy;
import se.rupy.http.Event;
import se.rupy.http.Hash;
import se.rupy.http.Input;

public class Query
extends Hash {
    public static final int GET = 1;
    public static final int POST = 2;
    public static final int PUT = 4;
    public static final int DELETE = 8;
    public static final int HEAD = 16;
    static URLDecoder decoder = new URLDecoder();
    private String path;
    private String version;
    private String parameters;
    private HashMap headers = new HashMap();
    private Input input;
    private int length;
    private int method;
    private long modified;
    private boolean done;
    private boolean parsed;

    protected Query(Event event) throws IOException {
        this.input = new Input.Chunked(event);
    }

    protected boolean headers() throws IOException {
        String connection;
        String content;
        this.headers.clear();
        String line = this.input.line();
        while (line.equals("")) {
            line = this.input.line();
        }
        StringTokenizer http = new StringTokenizer(line, " ");
        String method = http.nextToken();
        if (method.equalsIgnoreCase("get")) {
            this.method = 1;
        } else if (method.equalsIgnoreCase("post")) {
            this.method = 2;
            this.parsed = false;
        } else if (method.equalsIgnoreCase("save")) {
            this.method = 4;
            this.parsed = false;
        } else if (method.equalsIgnoreCase("delete")) {
            this.method = 8;
            this.parsed = false;
        } else if (method.equalsIgnoreCase("head")) {
            this.method = 16;
        } else {
            return false;
        }
        String get = http.nextToken();
        int index = get.indexOf(63);
        if (index > 0) {
            this.path = URLDecoder.decode(get.substring(0, index), "UTF-8");
            this.parameters = get.substring(index + 1);
            this.parsed = false;
        } else {
            this.path = URLDecoder.decode(get, "UTF-8");
            this.parameters = null;
        }
        this.version = http.nextToken();
        line = this.input.line();
        int lines = 0;
        while (line != null && !line.equals("")) {
            int colon = line.indexOf(":");
            if (colon > -1) {
                String name = line.substring(0, colon).toLowerCase();
                String value = line.substring(colon + 1).trim();
                this.headers.put(name, value);
            }
            line = this.input.line();
            if (++lines <= 30) continue;
            throw new IOException("Too many headers.");
        }
        String encoding = this.header("transfer-encoding");
        this.length = encoding != null && encoding.equalsIgnoreCase("chunked") ? -1 : ((content = this.header("content-length")) != null ? Integer.parseInt(content) : 0);
        String since = this.header("if-modified-since");
        if (since != null && since.length() > 0) {
            try {
                this.modified = this.input.event().worker().date().parse(since).getTime();
            }
            catch (ParseException e) {
                this.modified = 0L;
            }
        }
        if ((connection = this.header("connection")) != null && connection.equalsIgnoreCase("close")) {
            this.input.event().close(true);
        }
        this.clear();
        this.input.event().log(method + " " + (this.length > -1 ? "" + this.length : "*") + " " + this.path + (this.parameters != null ? "?" + this.parameters : ""), Event.VERBOSE);
        this.input.init();
        return true;
    }

    public void parse() throws Exception {
        this.parse(this.input.event().daemon().size);
    }

    public void parse(int size) throws Exception {
        ByteArrayOutputStream out;
        if (this.parsed) {
            return;
        }
        this.parsed = true;
        if (this.method == 2 && Deploy.pipe(this.input, out = new ByteArrayOutputStream(), size, size) > 0) {
            this.parameters = new String(out.toByteArray());
        }
        this.input.event().log("query " + this.parameters, Event.VERBOSE);
        if (this.parameters != null) {
            StringTokenizer amp = new StringTokenizer(this.parameters, "&");
            while (amp.hasMoreTokens()) {
                String equ = amp.nextToken();
                int pos = equ.indexOf(61);
                String key = null;
                String value = "false";
                if (pos == -1) {
                    pos = equ.length();
                    key = equ.substring(0, pos);
                } else {
                    key = equ.substring(0, pos);
                    value = equ.length() > pos + 1 ? URLDecoder.decode(equ.substring(pos + 1), "UTF-8") : "";
                }
                this.put(key, value);
            }
        }
    }

    protected void done() throws IOException {
        this.input.end();
        this.modified = 0L;
    }

    public int method() {
        return this.method;
    }

    public String path() {
        return this.path;
    }

    public String version() {
        return this.version;
    }

    public String type() {
        return this.header("content-type");
    }

    public long modified() {
        return this.modified;
    }

    public int length() {
        return this.length;
    }

    public String header(String name) {
        return (String)this.headers.get(name.toLowerCase());
    }

    protected void header(String name, String value) {
        this.headers.put(name, value);
    }

    public String parameters() {
        return this.parameters;
    }

    public HashMap header() {
        return this.headers;
    }

    public Input input() {
        return this.input;
    }
}

