/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.visitorimpl;

import com.brandon3055.brandonscore.client.gui.modulargui.markdown.MDElementContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.TableElement;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.lib.CellData;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.lib.VAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.visitor.MarkdownVisitor;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.visitor.property.TableVisitor;

public class TableVisitorImpl
extends TableVisitor {
    private TableElement element;
    private int cellColour = 0;
    private boolean hasCellColour = false;
    private int headingColour = 0;
    private boolean hasHeadingColour = false;
    private int leftPadding = 0;
    private int rightPadding = 0;
    private int topPadding = 0;
    private int bottomPadding = 0;
    private VAlign vertAlignment = VAlign.TOP;

    public TableVisitorImpl(TableElement element) {
        this.element = element;
    }

    @Override
    public void visitColour(int cellColour) {
        this.cellColour = cellColour;
        this.hasCellColour = true;
    }

    @Override
    public void visitBorderColour(int borderColour) {
        this.element.setColourBorder(borderColour);
    }

    @Override
    public void visitHeadingColour(int headingColour) {
        this.headingColour = headingColour;
        this.hasHeadingColour = true;
    }

    @Override
    public void visitWidth(int width, boolean screenRelative) {
        this.element.width = width;
        this.element.screenRelativeSize = screenRelative;
    }

    @Override
    public void visitHeight(int height) {
        this.element.height = height;
    }

    @Override
    public void visitVertAlign(VAlign vertAlignment) {
        this.vertAlignment = vertAlignment;
    }

    @Override
    public void visitRenderCells(boolean renderCells) {
        this.element.renderCells = renderCells;
    }

    @Override
    public void visitTableRow(String row) {
    }

    @Override
    public void visitLeftPad(int leftPadding) {
        this.leftPadding = leftPadding;
    }

    @Override
    public void visitRightPad(int rightPadding) {
        this.rightPadding = rightPadding;
    }

    @Override
    public void visitTopPad(int topPadding) {
        this.topPadding = topPadding;
    }

    @Override
    public void visitBottomPad(int bottomPadding) {
        this.bottomPadding = bottomPadding;
    }

    @Override
    public MarkdownVisitor getCellVisitor(CellData data) {
        TableElement.TableCellContainer tableCell = this.element.getCreateCell(data);
        MarkdownVisitor visitor = tableCell.createContainer();
        MDElementContainer container = tableCell.container;
        int lPad = data.lPad != -9999 ? data.lPad : this.leftPadding;
        int rPad = data.rPad != -9999 ? data.rPad : this.rightPadding;
        int tPad = data.tPad != -9999 ? data.tPad : this.topPadding;
        int bPad = data.bPad != -9999 ? data.bPad : this.bottomPadding;
        container.setInsets(tPad, lPad, bPad, rPad);
        if (data.colourSet) {
            tableCell.background.setFillColour(0xFF000000 | data.colour);
        } else if (this.hasHeadingColour && data.row == 0) {
            tableCell.background.setFillColour(0xFF000000 | this.headingColour);
        } else if (this.hasCellColour) {
            tableCell.background.setFillColour(0xFF000000 | this.cellColour);
        }
        if (data.vAlign == null) {
            data.vAlign = this.vertAlignment;
        }
        return visitor;
    }

    @Override
    public void endVisit() {
        this.element.invalidProps.addAll(this.invalidCalls.keySet());
    }
}

