/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiPopUpDialogBase;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTextField;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiEvent;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IGuiEventListener;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;

public class GuiTextFieldDialog
extends GuiPopUpDialogBase<GuiTextFieldDialog>
implements IGuiEventListener {
    private String title = "";
    public int titleColour = 0xFFFFFF;
    public GuiTextField textField;
    public GuiButton okButton;
    protected int maxLength = 64;
    protected String defaultText = "";
    protected Predicate<String> validator = null;
    protected Consumer<String> changeCallBack;
    protected Consumer<String> confirmCallBack;
    protected IGuiEventListener listener;

    public GuiTextFieldDialog(MGuiElementBase parent) {
        super(parent);
        this.setSize(200, 20);
    }

    public GuiTextFieldDialog(MGuiElementBase parent, String title) {
        super(parent);
        this.title = title;
        this.setSize(200, 40);
        this.setDragBar(15);
        this.setInsets(18, 3, 3, 3);
    }

    public GuiTextFieldDialog(int xPos, int yPos, MGuiElementBase parent) {
        super(xPos, yPos, parent);
        this.setSize(200, 20);
    }

    public GuiTextFieldDialog(int xPos, int yPos, int xSize, int ySize, MGuiElementBase parent) {
        super(xPos, yPos, xSize, ySize, parent);
        this.setSize(200, 20);
    }

    @Override
    public void addChildElements() {
        this.textField = ((GuiTextField)((GuiTextField)new GuiTextField().setPosAndSize(this.getInsetRect())).setXSize(this.getInsetRect().width - 20)).setListener(this);
        this.addChild(this.textField);
        this.textField.setMaxStringLength(this.maxLength);
        this.textField.setText(this.defaultText);
        if (this.validator != null) {
            this.textField.setValidator(this.validator);
        }
        this.okButton = new GuiButton(this.textField.maxXPos(), this.textField.yPos(), 20, this.textField.ySize(), I18n.func_135052_a((String)"generic.ok.txt", (Object[])new Object[0])).setTrim(false).setFillColour(-16777216).setBorderColours(-11184811, -8947849);
        this.addChild(this.okButton);
        this.okButton.setListener(() -> {
            if (this.confirmCallBack != null) {
                this.confirmCallBack.accept(this.textField.getText());
            }
            if (this.listener != null) {
                this.listener.onMGuiEvent(new GuiEvent.TextFieldEvent(this.textField, this.textField.getText(), false, true), this.textField);
            }
            this.close();
        });
        super.addChildElements();
    }

    @Override
    public void onMGuiEvent(GuiEvent event, MGuiElementBase eventElement) {
        if (event.isTextFiled()) {
            if (this.listener != null) {
                this.listener.onMGuiEvent(event, eventElement);
            }
            if (event.asTextField().textChanged() && this.changeCallBack != null) {
                this.changeCallBack.accept(this.textField.getText());
            } else if (event.asTextField().textEnterPressed() && this.confirmCallBack != null) {
                this.confirmCallBack.accept(this.textField.getText());
            }
            if (event.asTextField().textEnterPressed()) {
                this.close();
            }
        }
    }

    public GuiTextFieldDialog setValidator(Predicate<String> validator) {
        this.validator = validator;
        if (this.textField != null) {
            this.textField.setValidator(validator);
        }
        return this;
    }

    public GuiTextFieldDialog setText(String text) {
        this.defaultText = text;
        if (this.textField != null) {
            this.textField.setText(text);
        }
        return this;
    }

    public GuiTextFieldDialog addTextChangeCallback(Consumer<String> changeCallBack) {
        this.changeCallBack = changeCallBack;
        return this;
    }

    public GuiTextFieldDialog addTextConfirmCallback(Consumer<String> confirmCallBack) {
        this.confirmCallBack = confirmCallBack;
        return this;
    }

    public GuiTextFieldDialog setListener(IGuiEventListener listener) {
        this.listener = listener;
        return this;
    }

    public GuiTextFieldDialog setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        if (this.textField != null) {
            this.textField.setMaxStringLength(maxLength);
        }
        return this;
    }

    public GuiTextFieldDialog setTitle(String title) {
        this.title = title;
        return this;
    }

    public GuiTextFieldDialog setTitleColour(int titleColour) {
        this.titleColour = titleColour;
        return this;
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        if (!this.title.isEmpty()) {
            this.drawString(this.fontRenderer, this.title, this.xPos() + 4, this.yPos() + 6, this.titleColour);
        }
    }
}

