/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.groups;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import oreexcavation.groups.BlockEntry;
import oreexcavation.utils.JsonHelper;

public class BlockGroups {
    public static final BlockGroups INSTANCE = new BlockGroups();
    private final Map<BlockEntry, String> staged = new HashMap<BlockEntry, String>();
    private final List<List<BlockEntry>> groupList = new ArrayList<List<BlockEntry>>();
    private final List<BlockEntry> strictSubs = new ArrayList<BlockEntry>();

    private BlockGroups() {
    }

    public String getStage(IBlockState state) {
        for (Map.Entry<BlockEntry, String> entry : this.staged.entrySet()) {
            if (!entry.getKey().checkMatch(state)) continue;
            return entry.getValue();
        }
        return null;
    }

    public List<BlockEntry> getGroup(IBlockState state) {
        ArrayList<BlockEntry> list = new ArrayList<BlockEntry>();
        block0: for (List<BlockEntry> l2 : this.groupList) {
            for (BlockEntry e : l2) {
                if (e == null || !e.checkMatch(state)) continue;
                list.addAll(l2);
                continue block0;
            }
        }
        return list;
    }

    public boolean isStrict(IBlockState state) {
        return this.quickCheck(this.strictSubs, state);
    }

    public boolean quickCheck(List<BlockEntry> list, IBlockState state) {
        if (list == null || state == null) {
            return false;
        }
        for (BlockEntry e : list) {
            if (e == null || !e.checkMatch(state)) continue;
            return true;
        }
        return false;
    }

    public void readFromJson(JsonObject json) {
        this.groupList.clear();
        for (JsonElement je1 : JsonHelper.GetArray(json, "blockGroups")) {
            if (je1 == null || !je1.isJsonArray()) continue;
            ArrayList<BlockEntry> list = new ArrayList<BlockEntry>();
            for (JsonElement je2 : je1.getAsJsonArray()) {
                BlockEntry entry;
                if (je2 == null || !je2.isJsonPrimitive() || (entry = BlockEntry.readFromString(je2.getAsString())) == null) continue;
                list.add(entry);
            }
            if (list.size() <= 0) continue;
            this.groupList.add(list);
        }
        this.strictSubs.clear();
        for (JsonElement je1 : JsonHelper.GetArray(json, "strictSubtypes")) {
            BlockEntry entry;
            if (je1 == null || !je1.isJsonPrimitive() || (entry = BlockEntry.readFromString(je1.getAsString())) == null) continue;
            this.strictSubs.add(entry);
        }
        for (Map.Entry entry : JsonHelper.GetObject(json, "gamestages").entrySet()) {
            BlockEntry be;
            if (entry.getValue() == null || !((JsonElement)entry.getValue()).isJsonPrimitive() || (be = BlockEntry.readFromString((String)entry.getKey())) == null) continue;
            this.staged.put(be, ((JsonElement)entry.getValue()).getAsString());
        }
    }

    public JsonObject getDefaultJson() {
        JsonObject json = new JsonObject();
        JsonArray ary1 = new JsonArray();
        JsonArray ary2 = new JsonArray();
        ary2.add((JsonElement)new JsonPrimitive("treeLeaves"));
        ary1.add((JsonElement)ary2);
        ary2 = new JsonArray();
        ary2.add((JsonElement)new JsonPrimitive("logWood"));
        ary1.add((JsonElement)ary2);
        json.add("blockGroups", (JsonElement)ary1);
        ary1 = new JsonArray();
        ary1.add((JsonElement)new JsonPrimitive("cropWheat"));
        ary1.add((JsonElement)new JsonPrimitive("cropPotato"));
        ary1.add((JsonElement)new JsonPrimitive("cropCarrot"));
        ary1.add((JsonElement)new JsonPrimitive("cropNetherWart"));
        json.add("strictSubtypes", (JsonElement)ary1);
        JsonObject obj2 = new JsonObject();
        obj2.addProperty("examplemod:example_block1", "example_stage1");
        obj2.addProperty("examplemod:example_block2", "example_stage2");
        json.add("gamestages", (JsonElement)obj2);
        return json;
    }
}

