/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.server.component.traits;

import li.cil.oc.Settings$;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.server.component.package$;
import li.cil.oc.server.component.traits.TankInventoryControl;
import li.cil.oc.util.ExtendedArguments;
import li.cil.oc.util.ExtendedArguments$;
import li.cil.oc.util.FluidUtils$;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Unit$;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public abstract class TankInventoryControl$class {
    @Callback(doc="function([slot:number]):number -- Get the amount of fluid in the tank item in the specified slot or the selected slot.")
    public static Object[] getTankLevelInSlot(TankInventoryControl $this, Context context, Arguments args) {
        return TankInventoryControl$class.withFluidInfo($this, $this.optSlot(args, 0), (Function2)new Serializable($this){

            public final Object[] apply(Option<FluidStack> fluid, int x$1) {
                return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fluid.fold((Function0)new Serializable(this){

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 0;
                    }
                }, (Function1)new Serializable(this){

                    public final int apply(FluidStack x$2) {
                        return x$2.amount;
                    }
                })}));
            }
        });
    }

    @Callback(doc="function([slot:number]):number -- Get the capacity of the tank item in the specified slot of the robot or the selected slot.")
    public static Object[] getTankCapacityInSlot(TankInventoryControl $this, Context context, Arguments args) {
        return TankInventoryControl$class.withFluidInfo($this, $this.optSlot(args, 0), (Function2)new Serializable($this){

            public final Object[] apply(Option<FluidStack> x$3, int capacity) {
                return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)capacity)}));
            }
        });
    }

    @Callback(doc="function([slot:number]):table -- Get a description of the fluid in the tank item in the specified slot or the selected slot.")
    public static Object[] getFluidInTankInSlot(TankInventoryControl $this, Context context, Arguments args) {
        return Settings$.MODULE$.get().allowItemStackInspection() ? TankInventoryControl$class.withFluidInfo($this, $this.optSlot(args, 0), (Function2)new Serializable($this){

            public final Object[] apply(Option<FluidStack> fluid, int x$4) {
                return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fluid.orNull(Predef$.MODULE$.$conforms())}));
            }
        }) : package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "not enabled in config"}));
    }

    @Callback(doc="function([tank:number]):table -- Get a description of the fluid in the tank in the specified slot or the selected slot.")
    public static Object[] getFluidInInternalTank(TankInventoryControl $this, Context context, Arguments args) {
        return Settings$.MODULE$.get().allowItemStackInspection() ? package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Option$.MODULE$.apply((Object)$this.tank().getFluidTank($this.optTank(args, 0))).map((Function1)new Serializable($this){

            public final FluidStack apply(IFluidTank x$5) {
                return x$5.getFluid();
            }
        }).orNull(Predef$.MODULE$.$conforms())})) : package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "not enabled in config"}));
    }

    @Callback(doc="function([amount:number]):boolean -- Transfers fluid from a tank in the selected inventory slot to the selected tank.")
    public static Object[] drain(TankInventoryControl $this, Context context, Arguments args) {
        Object[] objectArray;
        ExtendedArguments.ExtendedArguments qual$1 = ExtendedArguments$.MODULE$.extendedArguments(args);
        int x$6 = 0;
        int x$7 = qual$1.optFluidCount$default$2();
        int amount = qual$1.optFluidCount(x$6, x$7);
        Option option = Option$.MODULE$.apply((Object)$this.tank().getFluidTank($this.selectedTank()));
        if (option instanceof Some) {
            Object[] objectArray2;
            Some some = (Some)option;
            IFluidTank into = (IFluidTank)some.x();
            ItemStack itemStack = $this.inventory().func_70301_a($this.selectedSlot());
            if (itemStack != null) {
                Object[] objectArray3;
                ItemStack itemStack2 = itemStack;
                Option option2 = Option$.MODULE$.apply((Object)FluidUtils$.MODULE$.fluidHandlerOf(itemStack2));
                if (option2 instanceof Some) {
                    Object[] objectArray4;
                    Some some2 = (Some)option2;
                    IFluidHandlerItem handler = (IFluidHandlerItem)some2.x();
                    FluidStack drained = handler.drain(amount, false);
                    int transferred = into.fill(drained, true);
                    if (transferred > 0) {
                        handler.drain(transferred, true);
                        $this.inventory().func_70299_a($this.selectedSlot(), handler.getContainer());
                        objectArray4 = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)transferred)}));
                    } else {
                        objectArray4 = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "incompatible or no fluid"}));
                    }
                    objectArray3 = objectArray4;
                } else {
                    objectArray3 = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "item is not a fluid container"}));
                }
                objectArray2 = objectArray3;
            } else {
                objectArray2 = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "nothing selected"}));
            }
            objectArray = objectArray2;
        } else {
            objectArray = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "no tank"}));
        }
        return objectArray;
    }

    @Callback(doc="function([amount:number]):boolean -- Transfers fluid from the selected tank to a tank in the selected inventory slot.")
    public static Object[] fill(TankInventoryControl $this, Context context, Arguments args) {
        Object[] objectArray;
        ExtendedArguments.ExtendedArguments qual$2 = ExtendedArguments$.MODULE$.extendedArguments(args);
        int x$8 = 0;
        int x$9 = qual$2.optFluidCount$default$2();
        int amount = qual$2.optFluidCount(x$8, x$9);
        Option option = Option$.MODULE$.apply((Object)$this.tank().getFluidTank($this.selectedTank()));
        if (option instanceof Some) {
            Object[] objectArray2;
            Some some = (Some)option;
            IFluidTank from = (IFluidTank)some.x();
            ItemStack itemStack = $this.inventory().func_70301_a($this.selectedSlot());
            if (itemStack != null) {
                Object[] objectArray3;
                ItemStack itemStack2 = itemStack;
                Option option2 = Option$.MODULE$.apply((Object)FluidUtils$.MODULE$.fluidHandlerOf(itemStack2));
                if (option2 instanceof Some) {
                    Object[] objectArray4;
                    FluidStack drained;
                    Some some2 = (Some)option2;
                    IFluidHandlerItem handler = (IFluidHandlerItem)some2.x();
                    int transferred = handler.fill(drained = from.drain(amount, false), true);
                    if (transferred > 0) {
                        from.drain(transferred, true);
                        $this.inventory().func_70299_a($this.selectedSlot(), handler.getContainer());
                        objectArray4 = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)transferred)}));
                    } else {
                        objectArray4 = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "incompatible or no fluid"}));
                    }
                    objectArray3 = objectArray4;
                } else {
                    objectArray3 = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "item is not a fluid container"}));
                }
                objectArray2 = objectArray3;
            } else {
                objectArray2 = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "nothing selected"}));
            }
            objectArray = objectArray2;
        } else {
            objectArray = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "no tank"}));
        }
        return objectArray;
    }

    private static Object[] withFluidInfo(TankInventoryControl $this, int slot, Function2 f) {
        ItemStack itemStack = $this.inventory().func_70301_a(slot);
        if (itemStack != null) {
            Object[] objectArray;
            Some some;
            Tuple2 tuple2;
            ItemStack itemStack2 = itemStack;
            Option option = TankInventoryControl$class.fluidInfo$1($this, itemStack2);
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).x()) != null) {
                Option fluid = (Option)tuple2._1();
                int capacity = tuple2._2$mcI$sp();
                objectArray = (Object[])f.apply((Object)fluid, (Object)BoxesRunTime.boxToInteger((int)capacity));
            } else {
                objectArray = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "item is not a fluid container"}));
            }
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
        throw new MatchError((Object)itemStack);
    }

    private static final Option fluidInfo$1(TankInventoryControl $this, ItemStack stack) {
        None$ none$;
        Some some;
        IFluidHandlerItem handler;
        Option option = Option$.MODULE$.apply((Object)FluidUtils$.MODULE$.fluidHandlerOf(stack));
        if (option instanceof Some && (handler = (IFluidHandlerItem)(some = (Some)option).x()).getTankProperties().length > 0) {
            IFluidTankProperties props = handler.getTankProperties()[0];
            none$ = Option$.MODULE$.apply((Object)new Tuple2((Object)Option$.MODULE$.apply((Object)props.getContents()), (Object)BoxesRunTime.boxToInteger((int)props.getCapacity())));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static void $init$(TankInventoryControl $this) {
    }
}

