/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.network;

import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.darkhax.bookshelf.lib.EnchantData;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public abstract class SerializableMessage<REQ extends SerializableMessage>
implements Serializable,
IMessage,
IMessageHandler<REQ, IMessage> {
    private static final long serialVersionUID = 3214832642504369023L;
    private static final Map<Class<?>, Pair<Reader, Writer>> handlers = new HashMap();
    private static final Map<Class<?>, Field[]> fieldCache = new HashMap();

    public abstract IMessage handleMessage(MessageContext var1);

    public final IMessage onMessage(REQ message, MessageContext context) {
        return ((SerializableMessage)message).handleMessage(context);
    }

    public final void fromBytes(ByteBuf buf) {
        try {
            Field[] clFields;
            Class<?> clazz = this.getClass();
            for (Field f : clFields = SerializableMessage.getClassFields(clazz)) {
                Class<?> type = f.getType();
                if (!SerializableMessage.acceptField(f, type)) continue;
                this.readField(f, type, buf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at reading packet " + this, e);
        }
    }

    public final void toBytes(ByteBuf buf) {
        try {
            Field[] clFields;
            Class<?> clazz = this.getClass();
            for (Field f : clFields = SerializableMessage.getClassFields(clazz)) {
                Class<?> type = f.getType();
                if (!SerializableMessage.acceptField(f, type)) continue;
                this.writeField(f, type, buf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at writing packet " + this, e);
        }
    }

    private static Field[] getClassFields(Class<?> clazz) {
        if (fieldCache.containsValue(clazz)) {
            return fieldCache.get(clazz);
        }
        Field[] fields = clazz.getFields();
        Arrays.sort(fields, (f1, f2) -> f1.getName().compareTo(f2.getName()));
        fieldCache.put(clazz, fields);
        return fields;
    }

    private final void writeField(Field field, Class<?> type, ByteBuf buf) throws IllegalArgumentException, IllegalAccessException {
        Pair<Reader, Writer> handler = SerializableMessage.getHandler(type);
        ((Writer)handler.getRight()).write(field.get(this), buf);
    }

    private final void readField(Field field, Class<?> type, ByteBuf buf) throws IllegalArgumentException, IllegalAccessException {
        Pair<Reader, Writer> handler = SerializableMessage.getHandler(type);
        field.set(this, ((Reader)handler.getLeft()).read(buf));
    }

    private static Pair<Reader, Writer> getHandler(Class<?> type) {
        Pair<Reader, Writer> pair = handlers.get(type);
        if (pair == null) {
            throw new RuntimeException("No R/W handler for  " + type);
        }
        return pair;
    }

    private static boolean acceptField(Field field, Class<?> type) {
        int mods = field.getModifiers();
        if (Modifier.isFinal(mods) || Modifier.isStatic(mods) || Modifier.isTransient(mods)) {
            return false;
        }
        return handlers.containsKey(type);
    }

    public static <T> void addIOHandler(Class<T> type, Reader<T> reader, Writer<T> writer) {
        handlers.put(type, (Pair<Reader, Writer>)Pair.of(reader, writer));
    }

    private static byte readByte(ByteBuf buf) {
        return buf.readByte();
    }

    private static void writeByte(byte b, ByteBuf buf) {
        buf.writeByte((int)b);
    }

    private static short readShort(ByteBuf buf) {
        return buf.readShort();
    }

    private static void writeShort(short s, ByteBuf buf) {
        buf.writeShort((int)s);
    }

    private static int readInt(ByteBuf buf) {
        return buf.readInt();
    }

    private static void writeInt(int i, ByteBuf buf) {
        buf.writeInt(i);
    }

    private static long readLong(ByteBuf buf) {
        return buf.readLong();
    }

    private static void writeLong(long l, ByteBuf buf) {
        buf.writeLong(l);
    }

    private static float readFloat(ByteBuf buf) {
        return buf.readFloat();
    }

    private static void writeFloat(float f, ByteBuf buf) {
        buf.writeFloat(f);
    }

    private static double readDouble(ByteBuf buf) {
        return buf.readDouble();
    }

    private static void writeDouble(double d, ByteBuf buf) {
        buf.writeDouble(d);
    }

    private static boolean readBoolean(ByteBuf buf) {
        return buf.readBoolean();
    }

    private static void writeBoolean(boolean b, ByteBuf buf) {
        buf.writeBoolean(b);
    }

    private static char readChar(ByteBuf buf) {
        return buf.readChar();
    }

    private static void writeChar(char c, ByteBuf buf) {
        buf.writeChar((int)c);
    }

    private static String readString(ByteBuf buf) {
        return ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    private static void writeString(String s, ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s);
    }

    private static NBTTagCompound readNBT(ByteBuf buf) {
        return ByteBufUtils.readTag((ByteBuf)buf);
    }

    private static void writeNBT(NBTTagCompound cmp, ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)cmp);
    }

    private static ItemStack readItemStack(ByteBuf buf) {
        return ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    private static void writeItemStack(ItemStack stack, ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
    }

    private static BlockPos readBlockPos(ByteBuf buf) {
        return BlockPos.func_177969_a((long)buf.readLong());
    }

    private static void writeBlockPos(BlockPos pos, ByteBuf buf) {
        buf.writeLong(pos.func_177986_g());
    }

    private static ResourceLocation readResourceLocation(ByteBuf buf) {
        return new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    private static void writeResourceLocation(ResourceLocation location, ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)location.toString());
    }

    private static IBlockState readState(ByteBuf buf) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf)));
        byte meta = buf.readByte();
        return block != null ? block.func_176203_a((int)meta) : Blocks.field_150350_a.func_176223_P();
    }

    private static void writeState(IBlockState state, ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)state.func_177230_c().getRegistryName().toString());
        buf.writeByte(state.func_177230_c().func_176201_c(state));
    }

    private static EnchantmentData readEnchantmentData(ByteBuf buf) {
        ResourceLocation id = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        int level = buf.readInt();
        return new EnchantmentData((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(id), level);
    }

    private static void writeEnchantmentData(EnchantmentData data, ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(data.field_76302_b != null && data.field_76302_b.getRegistryName() != null ? data.field_76302_b.getRegistryName().toString() : "invalid"));
        buf.writeInt(data.field_76303_c);
    }

    private static EnchantData readEnchantData(ByteBuf buf) {
        ResourceLocation id = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        int level = buf.readInt();
        return new EnchantData((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(id), level);
    }

    private static void writeEnchantData(EnchantData data, ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(data.field_76302_b != null && data.field_76302_b.getRegistryName() != null ? data.field_76302_b.getRegistryName().toString() : "invalid"));
        buf.writeInt(data.field_76303_c);
    }

    private static String[] readStringArray(ByteBuf buf) {
        String[] strings = new String[buf.readInt()];
        for (int index = 0; index < strings.length; ++index) {
            strings[index] = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        return strings;
    }

    private static void writeStringArray(String[] strings, ByteBuf buf) {
        buf.writeInt(strings.length);
        for (String string : strings) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)string);
        }
    }

    private static byte[] readByteArray(ByteBuf buf) {
        byte[] objects = new byte[buf.readInt()];
        for (int index = 0; index < objects.length; ++index) {
            objects[index] = buf.readByte();
        }
        return objects;
    }

    private static void writeByteArray(byte[] objects, ByteBuf buf) {
        buf.writeInt(objects.length);
        for (byte object : objects) {
            buf.writeByte((int)object);
        }
    }

    private static short[] readShortArray(ByteBuf buf) {
        short[] objects = new short[buf.readInt()];
        for (int index = 0; index < objects.length; ++index) {
            objects[index] = buf.readShort();
        }
        return objects;
    }

    private static void writeShortArray(short[] objects, ByteBuf buf) {
        buf.writeInt(objects.length);
        for (short object : objects) {
            buf.writeShort((int)object);
        }
    }

    private static int[] readIntArray(ByteBuf buf) {
        int[] objects = new int[buf.readInt()];
        for (int index = 0; index < objects.length; ++index) {
            objects[index] = buf.readInt();
        }
        return objects;
    }

    private static void writeIntArray(int[] objects, ByteBuf buf) {
        buf.writeInt(objects.length);
        for (int object : objects) {
            buf.writeInt(object);
        }
    }

    private static long[] readLongArray(ByteBuf buf) {
        long[] objects = new long[buf.readInt()];
        for (int index = 0; index < objects.length; ++index) {
            objects[index] = buf.readLong();
        }
        return objects;
    }

    private static void writeLongArray(long[] objects, ByteBuf buf) {
        buf.writeInt(objects.length);
        for (long object : objects) {
            buf.writeLong(object);
        }
    }

    private static float[] readFloatArray(ByteBuf buf) {
        float[] objects = new float[buf.readInt()];
        for (int index = 0; index < objects.length; ++index) {
            objects[index] = buf.readFloat();
        }
        return objects;
    }

    private static void writeFloatArray(float[] objects, ByteBuf buf) {
        buf.writeInt(objects.length);
        for (float object : objects) {
            buf.writeFloat(object);
        }
    }

    private static double[] readDoubleArray(ByteBuf buf) {
        double[] objects = new double[buf.readInt()];
        for (int index = 0; index < objects.length; ++index) {
            objects[index] = buf.readDouble();
        }
        return objects;
    }

    private static void writeDoubleArray(double[] objects, ByteBuf buf) {
        buf.writeInt(objects.length);
        for (double object : objects) {
            buf.writeDouble(object);
        }
    }

    private static boolean[] readBooleanArray(ByteBuf buf) {
        boolean[] objects = new boolean[buf.readInt()];
        for (int index = 0; index < objects.length; ++index) {
            objects[index] = buf.readBoolean();
        }
        return objects;
    }

    private static void writeBooleanArray(boolean[] objects, ByteBuf buf) {
        buf.writeInt(objects.length);
        for (boolean object : objects) {
            buf.writeBoolean(object);
        }
    }

    private static char[] readCharArray(ByteBuf buf) {
        char[] objects = new char[buf.readInt()];
        for (int index = 0; index < objects.length; ++index) {
            objects[index] = buf.readChar();
        }
        return objects;
    }

    private static void writeCharArray(char[] objects, ByteBuf buf) {
        buf.writeInt(objects.length);
        for (char object : objects) {
            buf.writeChar((int)object);
        }
    }

    private static NBTTagCompound[] readNBTArray(ByteBuf buf) {
        NBTTagCompound[] objects = new NBTTagCompound[buf.readInt()];
        for (int index = 0; index < objects.length; ++index) {
            objects[index] = SerializableMessage.readNBT(buf);
        }
        return objects;
    }

    private static void writeNBTArray(NBTTagCompound[] objects, ByteBuf buf) {
        buf.writeInt(objects.length);
        for (NBTTagCompound object : objects) {
            SerializableMessage.writeNBT(object, buf);
        }
    }

    private static ItemStack[] readItemStackArray(ByteBuf buf) {
        ItemStack[] objects = new ItemStack[buf.readInt()];
        for (int index = 0; index < objects.length; ++index) {
            objects[index] = SerializableMessage.readItemStack(buf);
        }
        return objects;
    }

    private static void writeItemStackArray(ItemStack[] objects, ByteBuf buf) {
        buf.writeInt(objects.length);
        for (ItemStack object : objects) {
            SerializableMessage.writeItemStack(object, buf);
        }
    }

    private static BlockPos[] readBlockPosArray(ByteBuf buf) {
        BlockPos[] objects = new BlockPos[buf.readInt()];
        for (int index = 0; index < objects.length; ++index) {
            objects[index] = SerializableMessage.readBlockPos(buf);
        }
        return objects;
    }

    private static void writeBlockPosArray(BlockPos[] objects, ByteBuf buf) {
        buf.writeInt(objects.length);
        for (BlockPos object : objects) {
            SerializableMessage.writeBlockPos(object, buf);
        }
    }

    private static ResourceLocation[] readResourceLocationArray(ByteBuf buf) {
        ResourceLocation[] objects = new ResourceLocation[buf.readInt()];
        for (int index = 0; index < objects.length; ++index) {
            objects[index] = SerializableMessage.readResourceLocation(buf);
        }
        return objects;
    }

    private static void writeResourceLocationArray(ResourceLocation[] objects, ByteBuf buf) {
        buf.writeInt(objects.length);
        for (ResourceLocation object : objects) {
            SerializableMessage.writeResourceLocation(object, buf);
        }
    }

    private static IBlockState[] readStateArray(ByteBuf buf) {
        IBlockState[] objects = new IBlockState[buf.readInt()];
        for (int index = 0; index < objects.length; ++index) {
            objects[index] = SerializableMessage.readState(buf);
        }
        return objects;
    }

    private static void writeStateArray(IBlockState[] objects, ByteBuf buf) {
        buf.writeInt(objects.length);
        for (IBlockState object : objects) {
            SerializableMessage.writeState(object, buf);
        }
    }

    private static EnchantmentData[] readEnchantmentDataArray(ByteBuf buf) {
        EnchantmentData[] objects = new EnchantmentData[buf.readInt()];
        for (int index = 0; index < objects.length; ++index) {
            objects[index] = SerializableMessage.readEnchantmentData(buf);
        }
        return objects;
    }

    private static void writeEnchantmentDataArray(EnchantmentData[] objects, ByteBuf buf) {
        buf.writeInt(objects.length);
        for (EnchantmentData object : objects) {
            SerializableMessage.writeEnchantmentData(object, buf);
        }
    }

    private static EnchantData[] readEnchantDataArray(ByteBuf buf) {
        EnchantData[] objects = new EnchantData[buf.readInt()];
        for (int index = 0; index < objects.length; ++index) {
            objects[index] = SerializableMessage.readEnchantData(buf);
        }
        return objects;
    }

    private static void writeEnchantDataArray(EnchantData[] objects, ByteBuf buf) {
        buf.writeInt(objects.length);
        for (EnchantData object : objects) {
            SerializableMessage.writeEnchantData(object, buf);
        }
    }

    static {
        SerializableMessage.addIOHandler(Byte.TYPE, SerializableMessage::readByte, SerializableMessage::writeByte);
        SerializableMessage.addIOHandler(Short.TYPE, SerializableMessage::readShort, SerializableMessage::writeShort);
        SerializableMessage.addIOHandler(Integer.TYPE, SerializableMessage::readInt, SerializableMessage::writeInt);
        SerializableMessage.addIOHandler(Long.TYPE, SerializableMessage::readLong, SerializableMessage::writeLong);
        SerializableMessage.addIOHandler(Float.TYPE, SerializableMessage::readFloat, SerializableMessage::writeFloat);
        SerializableMessage.addIOHandler(Double.TYPE, SerializableMessage::readDouble, SerializableMessage::writeDouble);
        SerializableMessage.addIOHandler(Boolean.TYPE, SerializableMessage::readBoolean, SerializableMessage::writeBoolean);
        SerializableMessage.addIOHandler(Character.TYPE, SerializableMessage::readChar, SerializableMessage::writeChar);
        SerializableMessage.addIOHandler(byte[].class, SerializableMessage::readByteArray, SerializableMessage::writeByteArray);
        SerializableMessage.addIOHandler(short[].class, SerializableMessage::readShortArray, SerializableMessage::writeShortArray);
        SerializableMessage.addIOHandler(int[].class, SerializableMessage::readIntArray, SerializableMessage::writeIntArray);
        SerializableMessage.addIOHandler(long[].class, SerializableMessage::readLongArray, SerializableMessage::writeLongArray);
        SerializableMessage.addIOHandler(float[].class, SerializableMessage::readFloatArray, SerializableMessage::writeFloatArray);
        SerializableMessage.addIOHandler(double[].class, SerializableMessage::readDoubleArray, SerializableMessage::writeDoubleArray);
        SerializableMessage.addIOHandler(boolean[].class, SerializableMessage::readBooleanArray, SerializableMessage::writeBooleanArray);
        SerializableMessage.addIOHandler(char[].class, SerializableMessage::readCharArray, SerializableMessage::writeCharArray);
        SerializableMessage.addIOHandler(String.class, SerializableMessage::readString, SerializableMessage::writeString);
        SerializableMessage.addIOHandler(NBTTagCompound.class, SerializableMessage::readNBT, SerializableMessage::writeNBT);
        SerializableMessage.addIOHandler(ItemStack.class, SerializableMessage::readItemStack, SerializableMessage::writeItemStack);
        SerializableMessage.addIOHandler(BlockPos.class, SerializableMessage::readBlockPos, SerializableMessage::writeBlockPos);
        SerializableMessage.addIOHandler(IBlockState.class, SerializableMessage::readState, SerializableMessage::writeState);
        SerializableMessage.addIOHandler(ResourceLocation.class, SerializableMessage::readResourceLocation, SerializableMessage::writeResourceLocation);
        SerializableMessage.addIOHandler(EnchantmentData.class, SerializableMessage::readEnchantmentData, SerializableMessage::writeEnchantmentData);
        SerializableMessage.addIOHandler(EnchantData.class, SerializableMessage::readEnchantData, SerializableMessage::writeEnchantData);
        SerializableMessage.addIOHandler(String[].class, SerializableMessage::readStringArray, SerializableMessage::writeStringArray);
        SerializableMessage.addIOHandler(NBTTagCompound[].class, SerializableMessage::readNBTArray, SerializableMessage::writeNBTArray);
        SerializableMessage.addIOHandler(ItemStack[].class, SerializableMessage::readItemStackArray, SerializableMessage::writeItemStackArray);
        SerializableMessage.addIOHandler(BlockPos[].class, SerializableMessage::readBlockPosArray, SerializableMessage::writeBlockPosArray);
        SerializableMessage.addIOHandler(IBlockState[].class, SerializableMessage::readStateArray, SerializableMessage::writeStateArray);
        SerializableMessage.addIOHandler(ResourceLocation[].class, SerializableMessage::readResourceLocationArray, SerializableMessage::writeResourceLocationArray);
        SerializableMessage.addIOHandler(EnchantmentData[].class, SerializableMessage::readEnchantmentDataArray, SerializableMessage::writeEnchantmentDataArray);
        SerializableMessage.addIOHandler(EnchantData[].class, SerializableMessage::readEnchantDataArray, SerializableMessage::writeEnchantDataArray);
    }

    public static interface Reader<T> {
        public T read(ByteBuf var1);
    }

    public static interface Writer<T> {
        public void write(T var1, ByteBuf var2);
    }
}

