/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.forgelin;

import com.google.common.collect.SetMultimap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.asm.ModAnnotation;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.shadowfacts.forgelin.KotlinAdapter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001H\u0002J\u0014\u0010\u0010\u001a\u00020\u000e2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\fH\u0002J \u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\n2\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0005R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lnet/shadowfacts/forgelin/ForgelinAutomaticEventSubscriber;", "", "()V", "DEFAULT_SUBSCRIPTION_SIDES", "Ljava/util/EnumSet;", "Lnet/minecraftforge/fml/relauncher/Side;", "kotlin.jvm.PlatformType", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "registered", "", "unregistered", "Ljava/lang/Class;", "hasObjectEventHandlers", "", "objectInstance", "hasStaticEventHandlers", "clazz", "parseModId", "", "containedMods", "Lnet/minecraftforge/fml/common/discovery/ASMDataTable$ASMData;", "subscriber", "parseTargetSides", "subscribeAutomatic", "", "mod", "Lnet/minecraftforge/fml/common/ModContainer;", "asm", "Lnet/minecraftforge/fml/common/discovery/ASMDataTable;", "currentSide", "Forgelin"})
public final class ForgelinAutomaticEventSubscriber {
    private static final EnumSet<Side> DEFAULT_SUBSCRIPTION_SIDES;
    private static final Logger LOGGER;
    private static final Set<Class<?>> unregistered;
    private static final Set<Object> registered;
    public static final ForgelinAutomaticEventSubscriber INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final void subscribeAutomatic(@NotNull ModContainer mod, @NotNull ASMDataTable asm, @NotNull Side currentSide) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(mod, "mod");
        Intrinsics.checkParameterIsNotNull(asm, "asm");
        Intrinsics.checkParameterIsNotNull(currentSide, "currentSide");
        SetMultimap setMultimap = asm.getAnnotationsFor(mod);
        if (setMultimap == null) {
            return;
        }
        SetMultimap modAnnotations = setMultimap;
        Set containedMods = modAnnotations.get((Object)Mod.class.getName());
        Set set = modAnnotations.get((Object)Mod.EventBusSubscriber.class.getName());
        Intrinsics.checkExpressionValueIsNotNull(set, "modAnnotations.get(Mod.E\u2026scriber::class.java.name)");
        Iterable iterable = set;
        void var8_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ASMDataTable.ASMData it;
            ASMDataTable.ASMData aSMData = it = (ASMDataTable.ASMData)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull(aSMData, "it");
            if (!INSTANCE.parseTargetSides(aSMData).contains(currentSide)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List subscribers = (List)destination$iv$iv;
        Loader loader = Loader.instance();
        Intrinsics.checkExpressionValueIsNotNull(loader, "Loader.instance()");
        ModClassLoader loader2 = loader.getModClassLoader();
        Iterator iterator2 = containedMods.iterator();
        while (iterator2.hasNext()) {
            ASMDataTable.ASMData containedMod;
            ASMDataTable.ASMData aSMData = containedMod = (ASMDataTable.ASMData)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(aSMData, "containedMod");
            Object v = aSMData.getAnnotationInfo().get("modid");
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String containedModId = (String)v;
            if (Intrinsics.areEqual(containedMod.getAnnotationInfo().get("modLanguageAdapter"), Reflection.getOrCreateKotlinClass(KotlinAdapter.class).getQualifiedName()) ^ true) {
                LOGGER.debug("Skipping @EventBusSubscriber injection for {} since it does not use KotlinAdapter", (Object)containedModId);
                continue;
            }
            LOGGER.debug("Attempting to register Kotlin @EventBusSubscriber objects for {}", (Object)containedModId);
            for (ASMDataTable.ASMData subscriber : subscribers) {
                try {
                    Collection collection;
                    Class<?> subscriberClass;
                    Set set2 = containedMods;
                    Intrinsics.checkExpressionValueIsNotNull(set2, "containedMods");
                    ASMDataTable.ASMData aSMData2 = subscriber;
                    Intrinsics.checkExpressionValueIsNotNull(aSMData2, "subscriber");
                    String ownerModId = this.parseModId(set2, aSMData2);
                    CharSequence $i$f$filterTo = ownerModId;
                    if ($i$f$filterTo == null || $i$f$filterTo.length() == 0) {
                        LOGGER.debug("Could not determine owning mod for @EventBusSubscriber on {} for mod {}", (Object)subscriber.getClassName(), (Object)mod.getModId());
                        continue;
                    }
                    if (Intrinsics.areEqual(containedModId, ownerModId) ^ true) {
                        LOGGER.debug("Skipping @EventBusSubscriber injection for {} since it is not for mod {}", (Object)subscriber.getClassName(), (Object)containedModId);
                        continue;
                    }
                    if (Class.forName(subscriber.getClassName(), false, (ClassLoader)loader2) == null) {
                        continue;
                    }
                    KClass<?> kotlinClass2 = JvmClassMappingKt.getKotlinClass(subscriberClass);
                    Object object = kotlinClass2.getObjectInstance();
                    if (object == null) {
                        object = KClasses.getCompanionObjectInstance(kotlinClass2);
                    }
                    if (object == null) {
                        continue;
                    }
                    Object objectInstance2 = object;
                    if (!this.hasStaticEventHandlers(subscriberClass) && !unregistered.contains(subscriberClass)) {
                        MinecraftForge.EVENT_BUS.unregister(subscriberClass);
                        collection = unregistered;
                        collection.add(subscriberClass);
                        LOGGER.debug("Unregistered static @EventBusSubscriber class {}", (Object)subscriber.getClassName());
                    }
                    if (!this.hasObjectEventHandlers(objectInstance2) || registered.contains(objectInstance2)) continue;
                    MinecraftForge.EVENT_BUS.register(objectInstance2);
                    collection = registered;
                    collection.add(objectInstance2);
                    LOGGER.debug("Registered @EventBusSubscriber object instance {}", (Object)subscriber.getClassName());
                }
                catch (Throwable e) {
                    LOGGER.error("An error occurred trying to load an @EventBusSubscriber object {} for modid {}", (Object)mod.getModId(), (Object)e);
                    throw (Throwable)new LoaderException(e);
                }
            }
        }
    }

    private final boolean hasObjectEventHandlers(Object objectInstance2) {
        boolean bl;
        block1: {
            Method[] $receiver$iv;
            Method[] methodArray = objectInstance2.getClass().getMethods();
            Intrinsics.checkExpressionValueIsNotNull(methodArray, "objectInstance.javaClass.methods");
            Method[] methodArray2 = $receiver$iv = methodArray;
            int n = methodArray2.length;
            for (int i = 0; i < n; ++i) {
                Method element$iv;
                Method it;
                Method method = it = (element$iv = methodArray2[i]);
                Intrinsics.checkExpressionValueIsNotNull(method, "it");
                if (!(!Modifier.isStatic(method.getModifiers()) && it.isAnnotationPresent(SubscribeEvent.class))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean hasStaticEventHandlers(Class<?> clazz) {
        boolean bl;
        block1: {
            Method[] $receiver$iv;
            Method[] methodArray = clazz.getMethods();
            Intrinsics.checkExpressionValueIsNotNull(methodArray, "clazz.methods");
            Method[] methodArray2 = $receiver$iv = methodArray;
            int n = methodArray2.length;
            for (int i = 0; i < n; ++i) {
                Method element$iv;
                Method it;
                Method method = it = (element$iv = methodArray2[i]);
                Intrinsics.checkExpressionValueIsNotNull(method, "it");
                if (!(Modifier.isStatic(method.getModifiers()) && it.isAnnotationPresent(SubscribeEvent.class))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final String parseModId(Set<ASMDataTable.ASMData> containedMods, ASMDataTable.ASMData subscriber) {
        String parsedModId;
        CharSequence charSequence;
        Object v = subscriber.getAnnotationInfo().get("modid");
        if (!(v instanceof String)) {
            v = null;
        }
        if ((charSequence = (CharSequence)(parsedModId = (String)v)) == null || charSequence.length() == 0) {
            return parsedModId;
        }
        return ASMDataTable.getOwnerModID(containedMods, (ASMDataTable.ASMData)subscriber);
    }

    private final EnumSet<Side> parseTargetSides(ASMDataTable.ASMData subscriber) {
        List parsedSides;
        Object v = subscriber.getAnnotationInfo().get("value");
        if (!(v instanceof List)) {
            v = null;
        }
        if ((parsedSides = (List)v) != null) {
            EnumSet<Side> targetSides = EnumSet.noneOf(Side.class);
            for (ModAnnotation.EnumHolder parsed : parsedSides) {
                String string = parsed.getValue();
                Intrinsics.checkExpressionValueIsNotNull(string, "parsed.value");
                targetSides.add(Side.valueOf((String)string));
            }
            EnumSet<Side> enumSet = targetSides;
            Intrinsics.checkExpressionValueIsNotNull(enumSet, "targetSides");
            return enumSet;
        }
        EnumSet<Side> enumSet = DEFAULT_SUBSCRIPTION_SIDES;
        Intrinsics.checkExpressionValueIsNotNull(enumSet, "DEFAULT_SUBSCRIPTION_SIDES");
        return enumSet;
    }

    private ForgelinAutomaticEventSubscriber() {
    }

    static {
        ForgelinAutomaticEventSubscriber forgelinAutomaticEventSubscriber;
        INSTANCE = forgelinAutomaticEventSubscriber = new ForgelinAutomaticEventSubscriber();
        DEFAULT_SUBSCRIPTION_SIDES = EnumSet.allOf(Side.class);
        LOGGER = LogManager.getLogger(ForgelinAutomaticEventSubscriber.class);
        unregistered = new LinkedHashSet();
        registered = new LinkedHashSet();
    }
}

