/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.checker.NewKotlinTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.checker.NullabilityChecker;
import org.jetbrains.annotations.NotNull;

public final class TypeIntersector {
    public static final TypeIntersector INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SimpleType intersectTypes$descriptors(@NotNull List<? extends SimpleType> types) {
        void $receiver$iv;
        SimpleType p2;
        void $receiver$iv2;
        Object initial$iv;
        Object object;
        Collection<Object> collection;
        boolean bl;
        Intrinsics.checkParameterIsNotNull(types, "types");
        boolean bl2 = bl = types.size() > 1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Size should be at least 2, but it is " + types.size();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ArrayList<SimpleType> inputTypes = new ArrayList<SimpleType>();
        for (SimpleType simpleType2 : types) {
            if (simpleType2.getConstructor() instanceof IntersectionTypeConstructor) {
                void $receiver$iv$iv;
                void $receiver$iv22;
                Collection<KotlinType> collection2 = simpleType2.getConstructor().getSupertypes();
                Intrinsics.checkExpressionValueIsNotNull(collection2, "type.constructor.supertypes");
                Iterable iterable = collection2;
                collection = inputTypes;
                void var6_9 = $receiver$iv22;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv22, 10));
                for (UnwrappedType item$iv$iv : $receiver$iv$iv) {
                    SimpleType simpleType3;
                    void it;
                    KotlinType kotlinType = item$iv$iv;
                    object = destination$iv$iv;
                    void v2 = it;
                    Intrinsics.checkExpressionValueIsNotNull(v2, "it");
                    SimpleType it2 = simpleType3 = FlexibleTypesKt.upperIfFlexible((KotlinType)v2);
                    SimpleType simpleType4 = simpleType2.isMarkedNullable() ? it2.makeNullableAsSpecified(true) : it2;
                    object.add(simpleType4);
                }
                object = (List)destination$iv$iv;
                ((ArrayList)collection).addAll((Collection)object);
                continue;
            }
            inputTypes.add(simpleType2);
        }
        Iterable iterable = inputTypes;
        ResultNullability accumulator$iv = initial$iv = ResultNullability.START;
        for (Object element$iv : $receiver$iv2) {
            UnwrappedType item$iv$iv;
            item$iv$iv = (UnwrappedType)element$iv;
            ResultNullability p1 = accumulator$iv;
            accumulator$iv = p1.combine(p2);
        }
        ResultNullability resultNullability = accumulator$iv;
        initial$iv = inputTypes;
        Collection destination$iv = new LinkedHashSet();
        for (Object item$iv : $receiver$iv) {
            void it;
            p2 = (SimpleType)item$iv;
            collection = destination$iv;
            object = resultNullability == ResultNullability.NOT_NULL ? SpecialTypesKt.makeSimpleTypeDefinitelyNotNullOrNotNull((SimpleType)it) : it;
            collection.add(object);
        }
        LinkedHashSet correctNullability = (LinkedHashSet)destination$iv;
        return this.intersectTypesWithoutIntersectionType(correctNullability);
    }

    /*
     * Unable to fully structure code
     */
    private final SimpleType intersectTypesWithoutIntersectionType(Set<? extends SimpleType> inputTypes) {
        if (inputTypes.size() == 1) {
            return (SimpleType)CollectionsKt.single((Iterable)inputTypes);
        }
        filteredSuperAndEqualTypes = new ArrayList<E>(inputTypes);
        v0 = filteredSuperAndEqualTypes.iterator();
        Intrinsics.checkExpressionValueIsNotNull(v0, "filteredSuperAndEqualTypes.iterator()");
        iterator = v0;
        while (iterator.hasNext()) {
            block7: {
                block8: {
                    upper = (SimpleType)iterator.next();
                    $receiver$iv = filteredSuperAndEqualTypes;
                    if (!($receiver$iv instanceof Collection) || !((Collection)$receiver$iv).isEmpty()) break block8;
                    v1 = false;
                    break block7;
                }
                for (T element$iv : $receiver$iv) {
                    lower = (SimpleType)element$iv;
                    if (lower == upper) ** GOTO lbl-1000
                    v2 = lower;
                    Intrinsics.checkExpressionValueIsNotNull(v2, "lower");
                    v3 = v2;
                    v4 = upper;
                    Intrinsics.checkExpressionValueIsNotNull(v4, "upper");
                    if (TypeIntersector.INSTANCE.isStrictSupertype(v3, (KotlinType)v4) || NewKotlinTypeChecker.INSTANCE.equalTypes(lower, (KotlinType)upper)) {
                        v5 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = false;
                    }
                    if (!v5) continue;
                    v1 = true;
                    break block7;
                }
                v1 = false;
            }
            if (!(strictSupertypeOrHasEqual = v1)) continue;
            iterator.remove();
        }
        upper = filteredSuperAndEqualTypes;
        v6 = upper = upper.isEmpty() == false;
        if (_Assertions.ENABLED && !upper) {
            var6_8 = "This collections cannot be empty! input types: " + CollectionsKt.joinToString$default(inputTypes, null, null, null, 0, null, null, 63, null);
            throw (Throwable)new AssertionError((Object)var6_8);
        }
        if (filteredSuperAndEqualTypes.size() < 2) {
            v7 = CollectionsKt.single((List)filteredSuperAndEqualTypes);
            Intrinsics.checkExpressionValueIsNotNull(v7, "filteredSuperAndEqualTypes.single()");
            return (SimpleType)v7;
        }
        constructor = new IntersectionTypeConstructor((Collection<KotlinType>)inputTypes);
        var13_12 = constructor;
        var12_13 = Annotations.Companion.getEMPTY();
        var14_14 = CollectionsKt.emptyList();
        v8 = constructor.createScopeForKotlinType();
        Intrinsics.checkExpressionValueIsNotNull(v8, "constructor.createScopeForKotlinType()");
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(var12_13, var13_12, var14_14, false, v8);
    }

    private final boolean isStrictSupertype(KotlinType subtype, KotlinType supertype) {
        NewKotlinTypeChecker newKotlinTypeChecker = NewKotlinTypeChecker.INSTANCE;
        NewKotlinTypeChecker $receiver = newKotlinTypeChecker;
        return $receiver.isSubtypeOf(subtype, supertype) && !$receiver.isSubtypeOf(supertype, subtype);
    }

    private TypeIntersector() {
    }

    static {
        TypeIntersector typeIntersector;
        INSTANCE = typeIntersector = new TypeIntersector();
    }

    private static final abstract class ResultNullability
    extends Enum<ResultNullability> {
        public static final /* enum */ ResultNullability START;
        public static final /* enum */ ResultNullability ACCEPT_NULL;
        public static final /* enum */ ResultNullability UNKNOWN;
        public static final /* enum */ ResultNullability NOT_NULL;
        private static final /* synthetic */ ResultNullability[] $VALUES;

        static {
            ResultNullability[] resultNullabilityArray = new ResultNullability[4];
            ResultNullability[] resultNullabilityArray2 = resultNullabilityArray;
            resultNullabilityArray[0] = START = new START("START", 0);
            resultNullabilityArray[1] = ACCEPT_NULL = new ACCEPT_NULL("ACCEPT_NULL", 1);
            resultNullabilityArray[2] = UNKNOWN = new UNKNOWN("UNKNOWN", 2);
            resultNullabilityArray[3] = NOT_NULL = new NOT_NULL("NOT_NULL", 3);
            $VALUES = resultNullabilityArray;
        }

        @NotNull
        public abstract ResultNullability combine(@NotNull UnwrappedType var1);

        @NotNull
        protected final ResultNullability getResultNullability(@NotNull UnwrappedType $receiver) {
            Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
            return $receiver.isMarkedNullable() ? ACCEPT_NULL : (NullabilityChecker.INSTANCE.isSubtypeOfAny($receiver) ? NOT_NULL : UNKNOWN);
        }

        public static ResultNullability[] values() {
            return (ResultNullability[])$VALUES.clone();
        }

        public static ResultNullability valueOf(String string) {
            return Enum.valueOf(ResultNullability.class, string);
        }

        public static final class START
        extends ResultNullability {
            @Override
            @NotNull
            public ResultNullability combine(@NotNull UnwrappedType nextType) {
                Intrinsics.checkParameterIsNotNull(nextType, "nextType");
                return this.getResultNullability(nextType);
            }

            START() {
            }
        }

        public static final class ACCEPT_NULL
        extends ResultNullability {
            @Override
            @NotNull
            public ResultNullability combine(@NotNull UnwrappedType nextType) {
                Intrinsics.checkParameterIsNotNull(nextType, "nextType");
                return this.getResultNullability(nextType);
            }

            ACCEPT_NULL() {
            }
        }

        public static final class UNKNOWN
        extends ResultNullability {
            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public ResultNullability combine(@NotNull UnwrappedType nextType) {
                void var3_3;
                ResultNullability resultNullability;
                Intrinsics.checkParameterIsNotNull(nextType, "nextType");
                ResultNullability it = resultNullability = this.getResultNullability(nextType);
                return it == ACCEPT_NULL ? (ResultNullability)this : var3_3;
            }

            UNKNOWN() {
            }
        }

        public static final class NOT_NULL
        extends ResultNullability {
            @Override
            @NotNull
            public NOT_NULL combine(@NotNull UnwrappedType nextType) {
                Intrinsics.checkParameterIsNotNull(nextType, "nextType");
                return this;
            }

            NOT_NULL() {
            }
        }
    }
}

