/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModSounds {
    public static final List<SoundEvent> SOUNDS = new ArrayList<SoundEvent>();
    public static final SoundEvent TAP_SQUEAK = ModSounds.registerSoundResource("tap_squeak");
    public static final SoundEvent ENTITY_WITHER_SPAWN_LOCAL = ModSounds.registerSoundResource("entity_wither_spawn_local");
    public static final SoundEvent ENTITY_WITHER_DEATH_LOCAL = ModSounds.registerSoundResource("entity_wither_death_local");
    public static final SoundEvent ENTITY_DRAGON_DEATH_LOCAL = ModSounds.registerSoundResource("entity_dragon_death_local");
    public static final SoundEvent CHICKEN_RISE = ModSounds.registerSoundResource("chicken_rise");

    public static SoundEvent registerSoundResource(String name) {
        return new SoundEvent(new ResourceLocation("mob_grinding_utils", name));
    }

    public static void init() {
        try {
            for (Field field : ModSounds.class.getDeclaredFields()) {
                Object obj = field.get(null);
                if (!(obj instanceof SoundEvent)) continue;
                SoundEvent sound = (SoundEvent)obj;
                String name = field.getName().toLowerCase(Locale.ENGLISH);
                ModSounds.registerSoundName(name, sound);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerSoundName(String name, SoundEvent sound) {
        SOUNDS.add(sound);
        sound.setRegistryName("mob_grinding_utils", name);
    }

    @Mod.EventBusSubscriber(modid="mob_grinding_utils")
    public static class RegistrationHandlerSounds {
        @SubscribeEvent
        public static void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
            ModSounds.init();
            IForgeRegistry registry = event.getRegistry();
            for (SoundEvent sounds : SOUNDS) {
                registry.register((IForgeRegistryEntry)sounds);
            }
        }
    }
}

