/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vliblegacy.m_guide.json.objects;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.valkyrieofnight.vlib.core.io.json.IJsonSerializer;
import com.valkyrieofnight.vlib.core.util.client.ColorUtil;
import com.valkyrieofnight.vliblegacy.lib.client.gui.VLGuiResources;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.container.VLEleContBase;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.container.list.VLContListV;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.sizablebox.VLElementGuiSizableBox;
import com.valkyrieofnight.vliblegacy.lib.util.ConditionFactoryUtil;
import com.valkyrieofnight.vliblegacy.m_guide.json.GuideHandler;
import com.valkyrieofnight.vliblegacy.m_guide.json.objects.GuideObject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.crafting.IConditionFactory;

public class GOContainerVertical
extends GuideObject {
    public static final GOContainerVertical BLANK = new GOContainerVertical();
    public boolean hasBackground = false;
    public int r;
    public int g;
    public int b;
    public int a;
    public List<GuideObject> content;
    public String conditionFactory;

    @Override
    public String getType() {
        return "vcontainer";
    }

    public String toString() {
        String str = "{";
        int i = 0;
        for (GuideObject guideObject : this.content) {
            str = str + guideObject.toString();
            if (i >= this.content.size()) continue;
            str = str + ",";
        }
        return str + "}";
    }

    @Override
    public void initElement(String baseAddress, VLEleContBase cont) {
        IConditionFactory cf = ConditionFactoryUtil.getConditionFactoryOrGenericTrue(this.conditionFactory);
        if (!cf.parse(null, null).getAsBoolean()) {
            return;
        }
        final String ba = baseAddress + "." + cont.getTotalElements() + this.getType();
        VLContListV hc = new VLContListV(ba){

            @Override
            public void addElements() {
                if (GOContainerVertical.this.hasBackground) {
                    VLElementGuiSizableBox gsb = new VLElementGuiSizableBox(ba + "." + 0 + "bg", VLGuiResources.METRO_A_WHITE);
                    this.addElement(gsb);
                    gsb.setColor(ColorUtil.calcMCColor(GOContainerVertical.this.r, GOContainerVertical.this.g, GOContainerVertical.this.b, GOContainerVertical.this.a));
                }
                for (GuideObject go : GOContainerVertical.this.content) {
                    go.initElement(ba, this);
                }
            }
        };
        cont.addElement(hc);
    }

    public static class GOContainerVerticalSerializer
    implements IJsonSerializer<GOContainerVertical> {
        public GOContainerVertical deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonElement conditionFactory;
            JsonElement ca;
            JsonElement cb;
            JsonElement cg;
            JsonElement cr;
            GOContainerVertical r = new GOContainerVertical();
            r.content = new ArrayList<GuideObject>();
            JsonObject jobj = json.getAsJsonObject();
            JsonArray jarr = jobj.get("content").getAsJsonArray();
            for (JsonElement je : jarr) {
                String type = je.getAsJsonObject().get("type").getAsString();
                Class c = GuideHandler.getTypes().get(type);
                if (c == null) {
                    // empty if block
                }
                r.content.add((GuideObject)context.deserialize(je, (Type)c));
            }
            JsonElement cbg = jobj.get("bgenabled");
            if (cbg != null) {
                r.hasBackground = cbg.getAsBoolean();
            }
            if ((cr = jobj.get("r")) != null) {
                r.r = cr.getAsInt();
            }
            if ((cg = jobj.get("g")) != null) {
                r.g = cg.getAsInt();
            }
            if ((cb = jobj.get("b")) != null) {
                r.b = cb.getAsInt();
            }
            if ((ca = jobj.get("a")) != null) {
                r.a = ca.getAsInt();
            }
            if ((conditionFactory = jobj.get("condition")) != null) {
                r.conditionFactory = conditionFactory.getAsString();
            }
            return r;
        }

        public JsonElement serialize(GOContainerVertical src, Type typeOfSrc, JsonSerializationContext context) {
            JsonArray jarr = new JsonArray();
            for (GuideObject go : src.content) {
                String type = go.getType();
                Class c = GuideHandler.getTypes().get(type);
                if (c == null) {
                    // empty if block
                }
                jarr.add(context.serialize((Object)go, (Type)c));
            }
            JsonObject r = new JsonObject();
            r.addProperty("type", src.getType());
            r.addProperty("bgenabled", Boolean.valueOf(src.hasBackground));
            r.addProperty("r", (Number)src.r);
            r.addProperty("g", (Number)src.g);
            r.addProperty("b", (Number)src.b);
            r.addProperty("a", (Number)src.a);
            r.addProperty("condition", src.conditionFactory);
            r.add("content", (JsonElement)jarr);
            return r;
        }
    }
}

