/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vliblegacy.lib.util;

import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;

public class ConfigCategoryUtil {
    public static boolean getBoolean(ConfigCategory cf, String name, boolean defaultValue, String comment, String langKey) {
        Property defaultProp = new Property(name, Boolean.toString(defaultValue), Property.Type.BOOLEAN);
        Property prop = (Property)cf.getOrDefault((Object)name, (Object)defaultProp);
        if (prop == defaultProp) {
            cf.put(name, prop);
        }
        prop.setLanguageKey(langKey);
        prop.setComment(comment + " [default: " + defaultValue + "]");
        return prop.getBoolean(defaultValue);
    }

    public static boolean getBoolean(ConfigCategory cf, String name, boolean defaultValue, String comment) {
        return ConfigCategoryUtil.getBoolean(cf, name, defaultValue, comment, name);
    }

    public static int getInt(ConfigCategory cf, String name, int defaultValue, String comment, String langKey) {
        Property defaultProp = new Property(name, Integer.toString(defaultValue), Property.Type.INTEGER);
        Property prop = (Property)cf.getOrDefault((Object)name, (Object)defaultProp);
        if (prop == defaultProp) {
            cf.put(name, prop);
        }
        prop.setLanguageKey(langKey);
        prop.setComment(comment + "[default: " + defaultValue + "]");
        return prop.getInt();
    }

    public static int getInt(ConfigCategory cf, String name, int defaultValue, String comment) {
        return ConfigCategoryUtil.getInt(cf, name, defaultValue, comment, name);
    }

    public static int getInt(ConfigCategory cf, String name, int defaultValue, int minValue, int maxValue, String comment, String langKey) {
        Property defaultProp = new Property(name, Integer.toString(defaultValue), Property.Type.INTEGER);
        Property prop = (Property)cf.getOrDefault((Object)name, (Object)defaultProp);
        if (prop == defaultProp) {
            cf.put(name, prop);
        }
        prop.setLanguageKey(langKey);
        prop.setComment(comment + " [range: " + minValue + " ~ " + maxValue + ", default: " + defaultValue + "]");
        prop.setMinValue(minValue);
        prop.setMaxValue(maxValue);
        return prop.getInt(defaultValue) < minValue ? minValue : (prop.getInt(defaultValue) > maxValue ? maxValue : prop.getInt(defaultValue));
    }

    public static int getInt(ConfigCategory cf, String name, int defaultValue, int minValue, int maxValue, String comment) {
        return ConfigCategoryUtil.getInt(cf, name, defaultValue, minValue, maxValue, comment, name);
    }

    public static double getDouble(ConfigCategory cf, String name, double defaultValue, String comment, String langKey) {
        Property defaultProp = new Property(name, Double.toString(defaultValue), Property.Type.DOUBLE);
        Property prop = (Property)cf.getOrDefault((Object)name, (Object)defaultProp);
        if (prop == defaultProp) {
            cf.put(name, prop);
        }
        prop.setLanguageKey(langKey);
        prop.setComment(comment + "[default: " + defaultValue + "]");
        return prop.getDouble();
    }

    public static double getDouble(ConfigCategory cf, String name, double defaultValue, String comment) {
        return ConfigCategoryUtil.getDouble(cf, name, defaultValue, comment, name);
    }

    public static double getDouble(ConfigCategory cf, String name, double defaultValue, double minValue, double maxValue, String comment, String langKey) {
        Property defaultProp = new Property(name, Double.toString(defaultValue), Property.Type.DOUBLE);
        Property prop = (Property)cf.getOrDefault((Object)name, (Object)defaultProp);
        if (prop == defaultProp) {
            cf.put(name, prop);
        }
        prop.setLanguageKey(langKey);
        prop.setComment(comment + " [range: " + minValue + " ~ " + maxValue + ", default: " + defaultValue + "]");
        prop.setMinValue(minValue);
        prop.setMaxValue(maxValue);
        return prop.getDouble(defaultValue) < minValue ? minValue : (prop.getDouble(defaultValue) > maxValue ? maxValue : prop.getDouble(defaultValue));
    }

    public static double getDouble(ConfigCategory cf, String name, double defaultValue, double minValue, double maxValue, String comment) {
        return ConfigCategoryUtil.getDouble(cf, name, defaultValue, minValue, maxValue, comment, name);
    }

    public static double getString(ConfigCategory cf, String name, String defaultValue, String comment, String langKey) {
        Property defaultProp = new Property(name, defaultValue, Property.Type.STRING);
        Property prop = (Property)cf.getOrDefault((Object)name, (Object)defaultProp);
        if (prop == defaultProp) {
            cf.put(name, prop);
        }
        prop.setLanguageKey(langKey);
        prop.setComment(comment + "[default: " + defaultValue + "]");
        return prop.getDouble();
    }

    public static double getString(ConfigCategory cf, String name, String defaultValue, String comment) {
        return ConfigCategoryUtil.getString(cf, name, defaultValue, comment, name);
    }
}

