/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vliblegacy.lib.sys.tile.tocker;

import com.valkyrieofnight.vliblegacy.lib.sys.tile.tocker.TockTracker;
import net.minecraft.world.World;

public interface IGeneratorTicker {
    public TockTracker getTracker();

    public World getTheWorld();

    default public void updateTicker() {
        if (this.getTracker().hasStarted()) {
            int tocks = this.getTracker().getValidTocks(this.getTickTocks());
            if ((tocks = this.checkEnergyStorage(tocks)) > 0) {
                if (!this.getTracker().isComplete()) {
                    this.onProcessTick(tocks);
                }
                if (this.getTracker().isComplete()) {
                    this.onComplete();
                    this.onStartAttempt();
                }
            } else {
                this.onIdleTick();
            }
        }
        if (!this.getTracker().hasStarted()) {
            this.onStartAttempt();
        }
    }

    default public void onStartAttempt() {
        this.onInitStart();
        if (this.checkValidResource() && this.checkEnergyStorage(1) > 0) {
            this.onStart();
            this.getTracker().resetTracker(this.getTockDurationFromResource());
            this.consumeResource();
            this.getTracker().startTracker();
        }
    }

    public void onInitStart();

    public void onStart();

    default public void onIdleTick() {
    }

    public void onComplete();

    public boolean checkValidResource();

    public void consumeResource();

    public int getTockDurationFromResource();

    public int getTickTocks();

    public int checkEnergyStorage(int var1);

    default public void onProcessTick(int tocks) {
        this.getTracker().tock(tocks);
        this.onProcessTocks(tocks);
    }

    public void onProcessTocks(int var1);
}

