/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vliblegacy.lib.sys.owner;

import com.mojang.authlib.GameProfile;
import com.valkyrieofnight.vlib.core.io.nbt.INBTSerializer;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;

public class Owner
implements INBTSerializer {
    public static final Owner NO_OWNER = new Owner();
    protected UUID uuid;
    protected String username;

    public Owner() {
        this.uuid = null;
        this.username = "NO_OWNER";
    }

    public Owner(@Nonnull UUID owner) {
        this.uuid = owner;
    }

    public Owner(@Nonnull GameProfile owner) {
        this.uuid = owner.getId();
        this.username = owner.getName();
    }

    public void setOwner(@Nonnull UUID owner) {
        this.uuid = owner;
    }

    public UUID getOwnerUUID() {
        return this.uuid;
    }

    public String getUsername(World world) {
        EntityPlayer pl;
        if (StringUtils.func_151246_b((String)this.username) && (pl = world.func_152378_a(this.getOwnerUUID())) != null) {
            this.username = pl.func_146103_bH().getName();
        }
        return this.username;
    }

    public boolean isOwner(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        return player.func_146103_bH().getId().equals(this.uuid);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.uuid != null) {
            nbt.func_74772_a("own_mst", this.uuid.getMostSignificantBits());
            nbt.func_74772_a("own_lst", this.uuid.getLeastSignificantBits());
        } else {
            this.username = Owner.NO_OWNER.username;
        }
        nbt.func_74778_a("own_un", this.username);
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("own_mst") && nbt.func_74764_b("own_lst")) {
            this.uuid = new UUID(nbt.func_74763_f("own_mst"), nbt.func_74763_f("own_lst"));
            this.username = nbt.func_74779_i("own_un");
        } else {
            this.username = Owner.NO_OWNER.username;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Owner)) {
            return false;
        }
        Owner o2 = (Owner)o;
        if (o2.uuid == null && o2.username.equals(Owner.NO_OWNER.username)) {
            return true;
        }
        return o2.uuid == this.uuid;
    }

    public String toString() {
        return this.username;
    }

    public EntityPlayer getFromWorld(World world) {
        if (this.uuid == null) {
            return null;
        }
        return world.func_152378_a(this.uuid);
    }

    public static Owner getFromNBT(NBTTagCompound nbt) {
        Owner o = new Owner();
        o.deserializeNBT(nbt);
        return o;
    }

    public static Owner getFromPlayer(@Nonnull EntityPlayer p) {
        if (p == null) {
            return NO_OWNER;
        }
        return new Owner(p.func_146103_bH());
    }
}

