/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vliblegacy.lib.multiblock;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.multiblock.api.tile.ITileController;
import com.valkyrieofnight.vlib.multiblock.api.tile.ITileSlave;
import com.valkyrieofnight.vliblegacy.lib.multiblock.tilemodule.StructureFormer;
import com.valkyrieofnight.vliblegacy.lib.tile.energy.VLTileEnergyConsumer;
import com.valkyrieofnight.vliblegacy.lib.tilemodule.progress.ITileProgress;
import com.valkyrieofnight.vliblegacy.lib.tilemodule.progress.ProgressTracker;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public abstract class VLControllerEConsumer
extends VLTileEnergyConsumer
implements ITileController,
ITileProgress {
    protected ProgressTracker progress = new ProgressTracker();
    protected StructureFormer former = new StructureFormer(this);

    public VLControllerEConsumer(int capacity) {
        this(capacity, capacity);
    }

    public VLControllerEConsumer(int capacity, int maxExtract) {
        super(capacity, maxExtract);
        this.addModule(this.former);
    }

    @Override
    public void updateTile() {
        if (!this.field_145850_b.field_72995_K) {
            // empty if block
        }
        if (this.former.isFormed() && this.former.getMBDirection() != -1) {
            if (!this.func_145831_w().func_175640_z(this.func_174877_v())) {
                this.updateProgress();
            } else {
                this.onIdleTick();
            }
        }
        super.updateTile();
    }

    @Override
    public NBTTagCompound saveTileData(NBTTagCompound nbt, boolean toItem) {
        super.saveTileData(nbt, toItem);
        if (toItem) {
            return nbt;
        }
        this.progress.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public void loadTileData(NBTTagCompound nbt, boolean fromItem) {
        super.loadTileData(nbt, fromItem);
        if (fromItem) {
            return;
        }
        this.progress.readFromNBT(nbt);
    }

    @Override
    public List<ITextComponent> getInfo() {
        ArrayList rt = Lists.newArrayList();
        rt.add(new TextComponentTranslation("infoarg.valkyrielib.owner", new Object[]{new TextComponentString(this.getOwner().getUsername(this.field_145850_b))}));
        return rt;
    }

    @Override
    public boolean isSlave(BlockPos pos) {
        return this.getStructure().getSlavesLayout(this.getTheWorld(), this.func_174877_v(), EnumFacing.func_82600_a((int)this.former.getMBDirection())).contains(pos);
    }

    @Override
    public void onSlaveBreak(ITileSlave slave, BlockPos pos) {
        this.deformMultiblock();
    }

    @Override
    public void deformMultiblock() {
        this.former.deformMultiblock();
    }

    @Override
    public boolean isFormed() {
        return this.former.isFormed();
    }

    @Override
    public ProgressTracker getTracker() {
        return this.progress;
    }

    @Override
    public World getTheWorld() {
        return this.field_145850_b;
    }

    @Override
    public EnumFacing getDirectionE() {
        return this.former.getMBDirectionE();
    }

    @Override
    public int getCurrentDuration() {
        int duration = (int)((float)this.getBaseDuration());
        if ((duration = this.modifyDuration(duration)) < this.getMinDuration()) {
            return this.getMinDuration();
        }
        if (duration > this.getMaxDuration()) {
            return this.getMaxDuration();
        }
        return duration;
    }

    @Override
    public boolean canStartProcess() {
        return this.isFormed();
    }

    @Override
    public int canProcess(int ticks) {
        return this.canProcess() ? 1 : 0;
    }

    @Override
    public int processTicks() {
        return 1;
    }

    @Override
    public void serverUpdate() {
    }

    @Override
    public void clientUpdate() {
    }

    public abstract int getBaseDuration();

    public abstract int getMinDuration();

    public abstract int getMaxDuration();

    public abstract int modifyDuration(int var1);

    public abstract boolean canProcess();

    @Override
    public boolean canSaveOnPickup() {
        return true;
    }
}

