/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.io.json.config.property.properties;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropBase;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropParserBase;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import java.util.List;
import javax.annotation.Nonnull;
import scala.actors.threadpool.Arrays;

public class PropString
extends PropBase<String> {
    public static final PropStringParser PARSER = new PropStringParser();
    protected List<String> valid = Lists.newArrayList();

    public PropString(String value, String ... validValues) {
        super(value);
        if (validValues != null && validValues.length > 0) {
            this.valid.addAll(Arrays.asList((Object[])validValues));
        }
    }

    @Override
    public PropParserBase getParser() {
        return PARSER;
    }

    @Override
    protected String validateData(String data) {
        if (this.valid.size() > 0) {
            for (String val : this.valid) {
                if (!val.equals(data)) continue;
                return data;
            }
            return this.valid.get(0);
        }
        return StringUtils.isNullOrEmpty(data) ? "" : data;
    }

    @Override
    public String getExtra() {
        if (this.valid.size() > 0) {
            String values = "";
            int validSize = this.valid.size();
            for (int i = 0; i < validSize; ++i) {
                values = i < validSize - 1 ? values + this.valid.get(i) + "," : values + this.valid.get(i);
            }
            return "[" + values + "]";
        }
        return "";
    }

    protected static class PropStringParser
    extends PropParserBase<PropString> {
        public PropStringParser() {
            super("st");
        }

        @Override
        public PropString fromJson(@Nonnull JsonElement json) throws Exception {
            return new PropString(json.getAsString(), new String[0]);
        }

        @Override
        public JsonElement toJson(@Nonnull PropString prop) throws Exception {
            return new JsonPrimitive((String)prop.getValue());
        }
    }
}

