/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.um.api.inventory;

import com.valkyrieofnight.um.api.modifier.IModifier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class ItemHandlerModifiable
extends ItemStackHandler
implements IItemHandler,
IItemHandlerModifiable {
    private boolean changedSinceLastCheck = false;

    public ItemHandlerModifiable(int modifierSlots) {
        this.stacks = NonNullList.func_191197_a((int)modifierSlots, (Object)ItemStack.field_190927_a);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        this.changedSinceLastCheck = true;
        if (stack.func_77973_b() instanceof IModifier || Block.func_149634_a((Item)stack.func_77973_b()) instanceof IModifier) {
            return super.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.changedSinceLastCheck = true;
        super.setStackInSlot(slot, stack);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.changedSinceLastCheck = true;
        return super.extractItem(slot, amount, simulate);
    }

    public boolean hasChanged() {
        if (this.changedSinceLastCheck) {
            this.changedSinceLastCheck = false;
            return true;
        }
        return false;
    }

    public void setChanged() {
        this.changedSinceLastCheck = true;
    }

    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }

    protected void onContentsChanged(int slot) {
        this.changedSinceLastCheck = true;
    }
}

