/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.core.event;

import java.util.ArrayList;
import java.util.HashSet;
import me.ichun.mods.ichunutil.common.block.BlockCompactPorkchop;
import me.ichun.mods.ichunutil.common.core.config.ConfigBase;
import me.ichun.mods.ichunutil.common.core.config.ConfigHandler;
import me.ichun.mods.ichunutil.common.core.tracker.EntityTrackerRegistry;
import me.ichun.mods.ichunutil.common.core.util.EventCalendar;
import me.ichun.mods.ichunutil.common.grab.GrabHandler;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.module.patron.PatronInfo;
import me.ichun.mods.ichunutil.common.packet.mod.PacketNewGrabbedEntityId;
import me.ichun.mods.ichunutil.common.packet.mod.PacketPatrons;
import me.ichun.mods.ichunutil.common.packet.mod.PacketUserShouldShowUpdates;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EventHandlerServer {
    public int ticks;
    public HashSet<PatronInfo> patrons = new HashSet();
    public EntityTrackerRegistry entityTrackerRegistry = new EntityTrackerRegistry();

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.entityTrackerRegistry.tick();
            GrabHandler.tick(Side.SERVER);
            ++this.ticks;
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END && EventCalendar.isAFDay() && (event.player.func_70608_bn() && event.player.func_70681_au().nextFloat() < 0.025f || event.player.func_70681_au().nextFloat() < 0.005f)) {
            event.player.func_130014_f_().func_184148_a(null, event.player.field_70165_t, event.player.field_70163_u + (double)event.player.func_70047_e(), event.player.field_70161_v, SoundEvents.field_187697_dL, SoundCategory.PLAYERS, event.player.func_70608_bn() ? 0.2f : 1.0f, (event.player.func_70681_au().nextFloat() - event.player.func_70681_au().nextFloat()) * 0.2f + 1.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        for (ConfigBase conf : ConfigHandler.configs) {
            if (conf.sessionProp.isEmpty()) continue;
            conf.sendPlayerSession(event.player);
        }
        iChunUtil.channel.sendTo(new PacketPatrons(null), event.player);
        iChunUtil.channel.sendTo(new PacketUserShouldShowUpdates(iChunUtil.config.versionNotificationTypes == 0 || iChunUtil.config.versionNotificationTypes == 1 && ((EntityPlayerMP)event.player).field_71133_b.func_184103_al().func_152596_g(event.player.func_146103_bH())), event.player);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ArrayList<GrabHandler> handlers = GrabHandler.getHandlers((EntityLivingBase)event.player, Side.SERVER);
        for (int i = handlers.size() - 1; i >= 0; --i) {
            GrabHandler handler = handlers.get(i);
            if (handler.canSendAcrossDimensions()) {
                GrabHandler.dimensionalEntities.add(handler.grabbed.func_145782_y());
                handler.grabbed.getEntityData().func_74768_a("Grabbed-ID", handler.grabbed.func_145782_y());
                handler.grabbed.func_184204_a(event.player.field_71093_bK);
                handler.update();
                continue;
            }
            handler.terminate();
            handlers.remove(i);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        this.patrons.remove(new PatronInfo(event.player.func_146103_bH().getId().toString().replaceAll("-", ""), 1, false));
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity().getEntityData().func_74764_b("Grabbed-ID")) {
            Integer x = event.getEntity().getEntityData().func_74762_e("Grabbed-ID");
            if (event.getEntity().func_145782_y() != x.intValue()) {
                for (int i = GrabHandler.dimensionalEntities.size() - 1; i >= 0; --i) {
                    if (!GrabHandler.dimensionalEntities.get(i).equals(x)) continue;
                    GrabHandler.dimensionalEntities.remove(i);
                    for (GrabHandler handler : GrabHandler.grabbedEntities.get(Side.SERVER)) {
                        if (handler.grabbed.func_145782_y() != x.intValue()) continue;
                        handler.grabbed = event.getEntity();
                        iChunUtil.channel.sendToAll(new PacketNewGrabbedEntityId(true, x, event.getEntity().func_145782_y()));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onRegisterBlock(RegistryEvent.Register<Block> event) {
        iChunUtil.blockCompactPorkchop = new BlockCompactPorkchop();
        event.getRegistry().register((IForgeRegistryEntry)iChunUtil.blockCompactPorkchop);
    }

    @SubscribeEvent
    public void onRegisterItem(RegistryEvent.Register<Item> event) {
        event.getRegistry().register(new ItemBlock(iChunUtil.blockCompactPorkchop).setRegistryName(iChunUtil.blockCompactPorkchop.getRegistryName()));
    }

    public void shuttingDownServer() {
        this.patrons.clear();
        this.entityTrackerRegistry.trackerEntries.clear();
        GrabHandler.grabbedEntities.get(Side.SERVER).clear();
        GrabHandler.dimensionalEntities.clear();
    }
}

